/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

public interface Driver {
    public Config config();

    public Browser browser();

    public WebDriver getWebDriver();

    public SelenideProxyServer getProxy();

    public WebDriver getAndCheckWebDriver();

    public void close();

    default public boolean hasWebDriverStarted() {
        return this.getWebDriver() != null;
    }

    default public boolean supportsJavascript() {
        return this.hasWebDriverStarted() && this.getWebDriver() instanceof JavascriptExecutor;
    }

    default public <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)((JavascriptExecutor)this.getWebDriver()).executeScript(jsCode, arguments);
    }

    default public String getUserAgent() {
        return (String)this.executeJavaScript("return navigator.userAgent;", new Object[0]);
    }

    default public SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(this.config(), this.getWebDriver());
    }

    default public Actions actions() {
        return new Actions(this.getWebDriver());
    }
}

