/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class BySelectorCollection
implements WebElementsCollection {
    private final Driver driver;
    private final SearchContext parent;
    private final By selector;

    public BySelectorCollection(Driver driver, By selector) {
        this(driver, null, selector);
    }

    public BySelectorCollection(Driver driver, SearchContext parent, By selector) {
        this.driver = driver;
        this.parent = parent;
        this.selector = selector;
    }

    @Override
    public List<WebElement> getElements() {
        SearchContext searchContext = this.parent == null ? this.driver.getWebDriver() : this.parent;
        return WebElementSelector.instance.findElements(this.driver, searchContext, this.selector);
    }

    @Override
    public String description() {
        return this.parent == null ? Describe.selector(this.selector) : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).getSearchCriteria() + "/" + Describe.shortly(this.selector) : Describe.shortly(this.selector));
    }

    @Override
    public Driver driver() {
        return this.driver;
    }
}

