/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.ex.SoftAssertionError;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.ArrayList;
import java.util.List;

public class ErrorsCollector
implements LogEventListener {
    public static final String LISTENER_SOFT_ASSERT = "softAssert";
    private final List<Throwable> errors = new ArrayList<Throwable>();

    @Override
    public void onEvent(LogEvent event) {
        if (event.getStatus() == LogEvent.EventStatus.FAIL) {
            this.errors.add(event.getError());
        }
    }

    public void clear() {
        this.errors.clear();
    }

    public void failIfErrors(String testName) {
        if (this.errors.size() == 1) {
            throw new SoftAssertionError(this.errors.get(0).toString());
        }
        if (!this.errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Test ").append(testName).append(" failed.\n");
            sb.append(this.errors.size()).append(" checks failed\n");
            int i = 0;
            for (Throwable error : this.errors) {
                sb.append("\nFAIL #").append(++i).append(": ");
                sb.append(error).append('\n');
            }
            throw new SoftAssertionError(sb.toString());
        }
    }

    public static void validateAssertionMode(Config config) {
        if (config.assertionMode() == AssertionMode.SOFT && !SelenideLogger.hasListener(LISTENER_SOFT_ASSERT)) {
            throw new IllegalStateException("Using soft asserts, but without @SoftAsserts annotation");
        }
    }
}

