/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class HtmlUnitDriverFactory
extends AbstractDriverFactory {
    HtmlUnitDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isHtmlUnit();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        return this.createHtmlUnitDriver(config, proxy);
    }

    private WebDriver createHtmlUnitDriver(Config config, Proxy proxy) {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (config.browser().indexOf(58) > -1) {
            String emulatedBrowser = config.browser().replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }
}

