/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

class PhantomJsDriverFactory
extends AbstractDriverFactory {
    PhantomJsDriverFactory() {
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isPhantomjs();
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        return this.createPhantomJsDriver(config, proxy);
    }

    private WebDriver createPhantomJsDriver(Config config, Proxy proxy) {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver", config, proxy);
    }
}

