/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.impl.PageSourceExtractor;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShotLaboratory {
    private static final Logger log = LoggerFactory.getLogger(ScreenShotLaboratory.class);
    private static final ScreenShotLaboratory instance = new ScreenShotLaboratory();
    protected final List<File> allScreenshots = new ArrayList<File>();
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected ThreadLocal<String> currentContext = ThreadLocal.withInitial(() -> "");
    protected ThreadLocal<List<File>> currentContextScreenshots = new ThreadLocal();

    public static ScreenShotLaboratory getInstance() {
        return instance;
    }

    protected ScreenShotLaboratory() {
    }

    public String takeScreenShot(Driver driver, String className, String methodName) {
        return this.takeScreenShot(driver, this.getScreenshotFileName(className, methodName));
    }

    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.timestamp();
    }

    public String takeScreenShot(Driver driver) {
        return this.takeScreenShot(driver, this.generateScreenshotFileName());
    }

    public String takeScreenShot(Driver driver, String fileName) {
        return this.ifWebDriverStarted(driver, webDriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenShot((Config)config, (WebDriver)webDriver, fileName)));
    }

    private String takeScreenShot(Config config, WebDriver webDriver, String fileName) {
        File imageFile;
        File screenshot = null;
        if (config.savePageSource()) {
            screenshot = this.savePageSourceToFile(config, fileName, webDriver);
        }
        if ((imageFile = this.savePageImageToFile(config, fileName, webDriver)) != null) {
            screenshot = imageFile;
        }
        if (screenshot == null) {
            return null;
        }
        return this.addToHistory(screenshot).getAbsolutePath();
    }

    public File takeScreenshot(Driver driver, WebElement element) {
        try {
            BufferedImage destination = this.takeScreenshotAsImage(driver, element);
            return this.writeToFile(driver, destination);
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {}", (Object)element, (Object)e);
            return null;
        }
    }

    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement element) {
        return this.ifWebDriverStarted(driver, webdriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenshotAsImage((WebDriver)webdriver, element)));
    }

    private BufferedImage takeScreenshotAsImage(WebDriver webdriver, WebElement element) {
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warn("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        byte[] screen = (byte[])((TakesScreenshot)webdriver).getScreenshotAs(OutputType.BYTES);
        Point elementLocation = element.getLocation();
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(screen));
            int elementWidth = this.getRescaledElementWidth(element, img);
            int elementHeight = this.getRescaledElementHeight(element, img);
            return img.getSubimage(elementLocation.getX(), elementLocation.getY(), elementWidth, elementHeight);
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {}", (Object)element, (Object)e);
            return null;
        }
        catch (RasterFormatException e) {
            log.warn("Cannot take screenshot because element is not displayed on current screen position");
            return null;
        }
    }

    protected String generateScreenshotFileName() {
        return this.currentContext.get() + this.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    protected void ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            log.info("Creating folder: {}", (Object)folder);
            if (!folder.mkdirs()) {
                log.error("Failed to create {}", (Object)folder);
            }
        }
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    public File takeScreenshot(Driver driver, WebElement iframe, WebElement element) {
        try {
            BufferedImage dest = this.takeScreenshotAsImage(driver, iframe, element);
            return this.writeToFile(driver, dest);
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {} inside frame {}", new Object[]{element, iframe, e});
            return null;
        }
    }

    private File writeToFile(Driver driver, BufferedImage dest) throws IOException {
        if (dest == null) {
            return null;
        }
        File screenshotOfElement = new File(driver.config().reportsFolder(), this.generateScreenshotFileName() + ".png");
        this.ensureFolderExists(screenshotOfElement);
        ImageIO.write((RenderedImage)dest, "png", screenshotOfElement);
        return screenshotOfElement;
    }

    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement iframe, WebElement element) {
        BufferedImage img;
        WebDriver webdriver = this.checkIfFullyValidDriver(driver);
        if (webdriver == null) {
            return null;
        }
        byte[] screen = (byte[])((TakesScreenshot)webdriver).getScreenshotAs(OutputType.BYTES);
        Point iframeLocation = iframe.getLocation();
        try {
            img = ImageIO.read(new ByteArrayInputStream(screen));
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {} inside frame {}", new Object[]{element, iframe, e});
            return null;
        }
        catch (RasterFormatException ex) {
            log.warn("Cannot take screenshot because iframe is not displayed");
            return null;
        }
        int iframeHeight = this.getRescaledElementHeight(iframe, img);
        SelenideTargetLocator switchTo = new SelenideTargetLocator(driver.config(), driver.getWebDriver());
        switchTo.frame(iframe);
        int iframeWidth = this.getRescaledIframeWidth(iframe, img, webdriver);
        Point elementLocation = element.getLocation();
        int elementWidth = this.getRescaledElementWidth(element, iframeWidth);
        int elementHeight = this.getRescaledElementHeight(element, iframeHeight);
        switchTo.defaultContent();
        try {
            img = img.getSubimage(iframeLocation.getX() + elementLocation.getX(), iframeLocation.getY() + elementLocation.getY(), elementWidth, elementHeight);
        }
        catch (RasterFormatException ex) {
            log.warn("Cannot take screenshot because element is not displayed in iframe");
            return null;
        }
        return img;
    }

    private WebDriver checkIfFullyValidDriver(Driver driver) {
        return this.ifWebDriverStarted(driver, this::checkIfFullyValidDriver);
    }

    private WebDriver checkIfFullyValidDriver(WebDriver webdriver) {
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warn("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        if (!(webdriver instanceof JavascriptExecutor)) {
            log.warn("Cannot take screenshot as driver is not supporting javascript execution");
            return null;
        }
        return webdriver;
    }

    public File takeScreenShotAsFile(Driver driver) {
        return this.ifWebDriverStarted(driver, this::takeScreenShotAsFile);
    }

    private File takeScreenShotAsFile(WebDriver webdriver) {
        File scrFile = this.getPageImage(webdriver);
        this.addToHistory(scrFile);
        return scrFile;
    }

    protected File getPageImage(WebDriver webdriver) {
        return webdriver instanceof TakesScreenshot ? this.takeScreenshotInMemory((TakesScreenshot)webdriver) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addToHistory(File screenshot) {
        if (this.currentContextScreenshots.get() != null) {
            this.currentContextScreenshots.get().add(screenshot);
        }
        List<File> list = this.allScreenshots;
        synchronized (list) {
            this.allScreenshots.add(screenshot);
        }
        return screenshot;
    }

    protected File takeScreenshotInMemory(TakesScreenshot driver) {
        try {
            return (File)driver.getScreenshotAs(OutputType.FILE);
        }
        catch (Exception e) {
            log.error("Failed to take screenshot in memory", (Throwable)e);
            return null;
        }
    }

    protected File savePageImageToFile(Config config, String fileName, WebDriver webdriver) {
        File imageFile = null;
        if (webdriver instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage(config, (TakesScreenshot)webdriver, fileName);
        }
        return imageFile;
    }

    protected File savePageSourceToFile(Config config, String fileName, WebDriver webdriver) {
        return new PageSourceExtractor(config, webdriver, fileName).extract(true);
    }

    protected File takeScreenshotImage(Config config, TakesScreenshot driver, String fileName) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(config.reportsFolder(), fileName + ".png");
            try {
                this.copyFile(scrFile, imageFile);
            }
            catch (IOException e) {
                log.error("Failed to save screenshot to {}", (Object)imageFile, (Object)e);
            }
            return imageFile;
        }
        catch (WebDriverException e) {
            log.error("Failed to take screenshot to {}", (Object)fileName, (Object)e);
            return null;
        }
    }

    protected void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);){
            this.copyFile(in, targetFile);
        }
    }

    protected void copyFile(InputStream in, File targetFile) throws IOException {
        this.ensureFolderExists(targetFile);
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext.set(context);
        this.currentContextScreenshots.set(new ArrayList());
    }

    public List<File> finishContext() {
        List<File> result = this.currentContextScreenshots.get();
        this.currentContext.set("");
        this.currentContextScreenshots.remove();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getScreenshots() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return Collections.unmodifiableList(this.allScreenshots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getLastScreenshot() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return this.allScreenshots.isEmpty() ? null : this.allScreenshots.get(this.allScreenshots.size() - 1);
        }
    }

    public String formatScreenShotPath(Driver driver) {
        if (!driver.config().screenshots()) {
            log.debug("Automatic screenshots are disabled.");
            return "";
        }
        String screenshot = this.takeScreenShot(driver);
        if (screenshot == null) {
            return "";
        }
        if (driver.config().reportsUrl() != null) {
            String screenshotUrl;
            Path target;
            Path current = Paths.get(System.getProperty("user.dir"), new String[0]);
            if (ScreenShotLaboratory.isInsideFolder(current, target = Paths.get(screenshot, new String[0]).normalize())) {
                Path relativePath = current.relativize(target);
                screenshotUrl = driver.config().reportsUrl() + relativePath.toString().replace('\\', '/');
            } else {
                String name = target.toFile().getName();
                screenshotUrl = driver.config().reportsUrl() + name;
            }
            try {
                screenshotUrl = new URL(screenshotUrl).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            log.debug("Replaced screenshot file path '{}' by public CI URL '{}'", (Object)screenshot, (Object)screenshotUrl);
            return screenshotUrl;
        }
        log.debug("reportsUrl is not configured. Returning screenshot file name '{}'", (Object)screenshot);
        try {
            return new File(screenshot).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return "file://" + screenshot;
        }
    }

    private static boolean isInsideFolder(Path root, Path other) {
        return other.startsWith(root.toAbsolutePath());
    }

    private <T> T ifWebDriverStarted(Driver driver, Function<WebDriver, T> lambda) {
        if (!driver.hasWebDriverStarted()) {
            log.warn("Cannot take screenshot because browser is not started");
            return null;
        }
        return lambda.apply(driver.getWebDriver());
    }

    private <T> T ifReportsFolderNotNull(Config config, Function<Config, T> lambda) {
        if (config.reportsFolder() == null) {
            log.error("Cannot take screenshot because reportsFolder is null");
            return null;
        }
        return lambda.apply(config);
    }

    private int getRescaledElementWidth(WebElement element, int iframeWidth) {
        int elementWidth = this.getElementWidth(element);
        if (elementWidth > iframeWidth) {
            return iframeWidth - element.getLocation().getX();
        }
        return elementWidth;
    }

    private int getRescaledElementHeight(WebElement element, int iframeHeight) {
        int elementHeight = this.getElementHeight(element);
        if (elementHeight > iframeHeight) {
            return iframeHeight - element.getLocation().getY();
        }
        return elementHeight;
    }

    private int getRescaledElementWidth(WebElement element, BufferedImage image) {
        if (this.getElementWidth(element) > image.getWidth()) {
            return image.getWidth() - element.getLocation().getX();
        }
        return this.getElementWidth(element);
    }

    private int getRescaledElementHeight(WebElement element, BufferedImage image) {
        if (this.getElementHeight(element) > image.getHeight()) {
            return image.getHeight() - element.getLocation().getY();
        }
        return this.getElementHeight(element);
    }

    private int getRescaledIframeWidth(WebElement iframe, BufferedImage image, WebDriver driver) {
        if (this.getIframeWidth(driver) > image.getWidth()) {
            return image.getWidth() - iframe.getLocation().getX();
        }
        return this.getIframeWidth(driver);
    }

    private int getIframeWidth(WebDriver driver) {
        return ((Long)((JavascriptExecutor)driver).executeScript("return document.body.clientWidth", new Object[0])).intValue();
    }

    private int getElementWidth(WebElement element) {
        return element.getSize().getWidth();
    }

    private int getElementHeight(WebElement element) {
        return element.getSize().getHeight();
    }
}

