/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.logevents.SimpleReport;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TextReportExtension
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private SimpleReport report = new SimpleReport();
    private boolean onFailedTest = true;
    private boolean onSucceededTest = true;

    public TextReportExtension onFailedTest(boolean onFailedTest) {
        this.onFailedTest = onFailedTest;
        return this;
    }

    public TextReportExtension onSucceededTest(boolean onSucceededTest) {
        this.onSucceededTest = onSucceededTest;
        return this;
    }

    public void beforeEach(ExtensionContext context) {
        if (this.onFailedTest || this.onSucceededTest) {
            this.report.start();
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.onFailedTest && context.getExecutionException().isPresent()) {
            this.report.finish(context.getDisplayName());
        } else if (this.onSucceededTest) {
            this.report.finish(context.getDisplayName());
        }
    }

    public void afterAll(ExtensionContext context) {
        this.report.clean();
    }
}

