/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

class SkipUntilSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private boolean conditionMet = false;

    static <T> SkipUntilSpliterator<T> over(Spliterator<T> source, Predicate<T> condition) {
        return new SkipUntilSpliterator<T>(source, condition);
    }

    private SkipUntilSpliterator(Spliterator<T> source, Predicate<T> condition) {
        this.source = source;
        this.condition = condition;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.conditionMet) {
            return this.source.tryAdvance(action);
        }
        while (!this.conditionMet && this.source.tryAdvance(e -> {
            this.conditionMet = this.condition.test(e);
            if (this.conditionMet) {
                action.accept(e);
            }
        })) {
        }
        return this.conditionMet;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (!this.conditionMet) {
            this.tryAdvance(action);
        }
        if (this.conditionMet) {
            this.source.forEachRemaining(action);
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.conditionMet ? this.source.estimateSize() : Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF;
    }
}

