/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.parsers;

import com.codesnippets4all.json.config.handlers.ConfigHandler;
import com.codesnippets4all.json.types.CollectionTypes;
import com.codesnippets4all.json.types.DefaultCollectionType;
import com.codesnippets4all.json.utils.CachedInstances;
import com.codesnippets4all.json.utils.JSONUtility;
import com.codesnippets4all.json.validations.custom.SpecialValidator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JSONParser {
    private int maxLength = -1;
    private Stack<String> tokenStack = new Stack();
    private List<String> heirarchyList = new ArrayList<String>(6);
    private StringBuilder key = new StringBuilder();
    private StringBuilder value = new StringBuilder();
    private String jsonBlockName = null;
    private boolean isValidating = false;
    private ConfigHandler configHandler = null;
    private CollectionTypes collectionTypes = null;

    public void setValidating(boolean isValidating) {
        this.isValidating = isValidating;
    }

    public void setConfigHandler(ConfigHandler configHandler) {
        this.configHandler = configHandler;
    }

    public void setCollectionTypes(CollectionTypes collectionTypes) {
        this.collectionTypes = collectionTypes;
    }

    public void initialize(InputStream is) {
        this.configHandler.setStream(is);
        this.configHandler.parse();
    }

    public void initializeWithJson(InputStream is) {
        this.configHandler.setStream(is);
        this.configHandler.parse();
    }

    public void initialize(String classPathResource) {
        InputStream is = JSONUtility.getStream(classPathResource);
        this.configHandler.setStream(is);
        this.configHandler.parse();
    }

    public Map parseJson(InputStream stream, String encoding) {
        String content = JSONUtility.readStream(stream, encoding);
        return this.parseJson(content);
    }

    public Map parseJson(String classPathResource, String encoding) {
        String content = JSONUtility.loadAndReadStream(classPathResource, encoding);
        return this.parseJson(content);
    }

    private Map getAssociatedMapType() {
        if (this.collectionTypes == null) {
            this.collectionTypes = new DefaultCollectionType();
        }
        return this.collectionTypes.getMapType();
    }

    private List getAssociatedListType() {
        if (this.collectionTypes == null) {
            this.collectionTypes = new DefaultCollectionType();
        }
        return this.collectionTypes.getListType();
    }

    public Map parseJson(String content) {
        if (content == null || content.trim().equals("")) {
            throw new IllegalArgumentException("input JSON string is null/empty...");
        }
        int index = 0;
        this.maxLength = content.length();
        this.heirarchyList.add("root");
        String pattern = null;
        pattern = !this.isValidating ? this.identifyApplicablePattern(content, index) : this.getPattern("ROOT", "valueType");
        this.heirarchyList.remove(0);
        Map completeJsonData = this.getAssociatedMapType();
        if (pattern == null || pattern.equalsIgnoreCase("JSON")) {
            do {
                Map jsonData = this.getAssociatedMapType();
                index = this.parseJsonBlock(content, index, jsonData);
                index = this.skipWhiteSpaceEOF(content, index);
                if (this.jsonBlockName.equals("root")) {
                    completeJsonData = jsonData;
                    break;
                }
                completeJsonData.put(this.jsonBlockName, jsonData);
            } while (index != -1);
        } else if (pattern.equalsIgnoreCase("JSON_ARRAY")) {
            if (!Character.isLetterOrDigit(content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf('[')))) && content.charAt(index) != '[') {
                ++index;
            }
            if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf('['))) == '[') {
                this.key.append("root");
                index = this.jsonArrayTemplate(content, index, completeJsonData, false);
            } else {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_ARRAY_START_TOKEN is expected but not found...@Position::", String.valueOf(index));
            }
            index = this.skipWhiteSpaceEOF(content, index);
        }
        if (index != -1) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_EOF is expected but unexpectedly found some data...@Position::", String.valueOf(index));
        }
        return completeJsonData;
    }

    private String identifyApplicablePattern(String content, int index) {
        if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf('['))) != '[' && content.charAt(index) != '{' && !Character.isLetterOrDigit(content.charAt(index))) {
            ++index;
        }
        if (content.charAt(index) == '[') {
            return "JSON_ARRAY";
        }
        return null;
    }

    private int parseJsonBlock(String content, int index, Map jsonData) {
        index = this.skipWhiteSpace(content, index, "var");
        index = this.consumeVarDeclarationIfAny(content, index);
        StringBuilder nameToken = new StringBuilder();
        index = this.consumeKeyOrName(content, index, nameToken, '=');
        this.verifyIfPatternMatches(nameToken.toString(), "[a-zA-Z0-9_]+");
        this.heirarchyList.add(nameToken.toString());
        this.jsonBlockName = nameToken.toString();
        index = this.parseJsonBody(content, index, jsonData);
        index = this.consumeSemiColonIfPresent(content, index, ';');
        return index;
    }

    private int consumeSemiColonIfPresent(String content, int index, char semicolon) {
        int tmpindex = this.skipWhiteSpaceEOF(content, index);
        if (tmpindex != -1 && content.charAt(tmpindex) == ';') {
            return tmpindex + 1;
        }
        return index;
    }

    private int parseJsonBody(String content, int index, Map jsonData) {
        index = this.consumeJsonBodyStartToken(content, index);
        index = this.parseKeysValues(content, index, jsonData);
        this.consumeJsonBodyEndToken(content, index);
        return index;
    }

    private void consumeJsonBodyEndToken(String content, int index) {
        if (this.tokenStack.isEmpty()) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Extra Close Curly Brace Occured...@Position::", String.valueOf(index));
        }
        this.tokenStack.pop();
        if (!this.heirarchyList.isEmpty()) {
            this.heirarchyList.remove(this.heirarchyList.size() - 1);
        }
    }

    private int parseKeysValues(String content, int index, Map jsonData) {
        int braceInd;
        do {
            this.key.delete(0, this.key.length());
            index = this.parseKey(content, index);
            this.value.delete(0, this.value.length());
            int tmpIndex = this.parseValue(content, index, jsonData);
            if (tmpIndex == -1) {
                Map tmpData = this.getAssociatedMapType();
                String tmpKey = this.key.toString();
                this.heirarchyList.add(tmpKey);
                index = this.parseJsonBody(content, index, tmpData);
                jsonData.put(tmpKey, tmpData);
                this.key.delete(0, this.key.length());
                index = this.skipWhiteSpace(content, index, ", or }");
                if (content.charAt(index) == ',' || content.charAt(index) == '}') {
                    ++index;
                } else {
                    JSONUtility.handleFailure(this.heirarchyList, this.key, "COMMA or Close Curly Brace is expected....@Position", String.valueOf(index));
                }
            } else {
                index = tmpIndex;
            }
            braceInd = this.verifyIfBracePresent(content, index);
        } while (braceInd == -1);
        return braceInd;
    }

    private void validateKey(int index) {
        String keyValidator = this.getPattern(this.key.toString(), "keyValidator");
        if (keyValidator != null) {
            SpecialValidator validator = CachedInstances.getInstance().getValidatorInstance(keyValidator);
            if (!validator.validate(this.key.toString(), this.heirarchyList)) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Key validation failed...json-block::", this.jsonBlockName, "\tKey::" + this.key + "\tValidator::", String.valueOf(keyValidator));
            }
            return;
        }
        String keyPattern = this.getPattern(this.key.toString(), "keyPattern");
        if (keyPattern != null && !this.key.toString().matches(keyPattern)) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, " is not matching the key pattern...@Position::", String.valueOf(index));
        }
    }

    private int verifyIfBracePresent(String content, int index) {
        if (content.charAt(index - 1) == '}') {
            return index;
        }
        if (content.charAt(index = this.skipWhiteSpace(content, index, "Key or }")) == '}') {
            return index + 1;
        }
        return -1;
    }

    private int parseKey(String content, int index) {
        int tempindex = index = this.skipWhiteSpace(content, index, String.valueOf(':'));
        index = this.consumeKeyOrName(content, index, this.key, ':');
        if (this.isValidating) {
            this.validateKey(tempindex);
        }
        return index;
    }

    private int parseValue(String content, int index, Map jsonData) {
        index = this.skipWhiteSpace(content, index, String.valueOf('{'));
        String valueType = null;
        valueType = !this.isValidating ? this.identifyValueTypePattern(content, index) : this.getPattern(this.key.toString(), "valueType");
        if (valueType != null && valueType.equalsIgnoreCase("JSON")) {
            if (content.charAt(index) == '{') {
                return -1;
            }
            JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_START_TOKEN is expected but not found...@Position::", String.valueOf(index));
        } else if (content.charAt(index) == '{') {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_START_TOKEN is identified but not expected...@Position::", String.valueOf(index));
        }
        if (valueType != null && valueType.equalsIgnoreCase("JSON_ARRAY")) {
            if (content.charAt(index) == '[') {
                return this.jsonArrayTemplate(content, index, jsonData, true);
            }
            JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_ARRAY_START_TOKEN is expected but not found...@Position::", String.valueOf(index));
        } else if (content.charAt(index) == '[') {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_ARRAY_START_TOKEN is identified but not expected...@Position::", String.valueOf(index));
        }
        index = !this.isValidating && valueType.equalsIgnoreCase("default") ? this.nonValidatingValueTemplate(content, index, '}', this.value) : this.determineTemplate(valueType, content, index, '}');
        jsonData.put(this.key.toString(), this.value.toString());
        return index + 1;
    }

    private String identifyValueTypePattern(String content, int index) {
        switch (content.charAt(index)) {
            case '{': {
                return "JSON";
            }
            case '[': {
                return "JSON_ARRAY";
            }
        }
        return "default";
    }

    private int jsonArrayTemplate(String content, int index, Map jsonData, boolean skipCommaOrCurlyBrace) {
        List dataList = this.getAssociatedListType();
        String tmpKey = this.key.toString();
        int arrayIndex = 0;
        do {
            index = this.skipWhiteSpace(content, index + 1, ", or ]");
            boolean flag = false;
            this.heirarchyList.add(tmpKey);
            String valueType = null;
            valueType = !this.isValidating ? this.identifyValueTypePattern(content, index) : this.getPattern(String.valueOf(arrayIndex), "valueType");
            if (valueType != null && valueType.equalsIgnoreCase("JSON_ARRAY") || content.charAt(index) == '[') {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_ARRAY cannot be the direct child of another JSON_ARRAY...@Position::", String.valueOf(index));
            }
            this.heirarchyList.remove(this.heirarchyList.size() - 1);
            this.heirarchyList.add(tmpKey + '[' + arrayIndex + ']');
            if (valueType != null && valueType.equalsIgnoreCase("JSON")) {
                if (content.charAt(index) == '{') {
                    Map dataMap = this.getAssociatedMapType();
                    index = this.parseJsonBody(content, index, dataMap);
                    dataList.add(dataMap);
                    index = this.skipWhiteSpace(content, index, String.valueOf(','));
                    flag = true;
                } else {
                    JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_START_TOKEN is expected but not found...@Position::", String.valueOf(index));
                }
            } else if (content.charAt(index) == '{') {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "JSON_START_TOKEN is identified but not expected...@Position::", String.valueOf(index));
            }
            if (!flag) {
                this.value.delete(0, this.value.length());
                this.key.delete(0, this.key.length());
                index = !this.isValidating && valueType.equalsIgnoreCase("default") ? this.nonValidatingValueTemplate(content, index, ']', this.value) : this.determineTemplate(valueType, content, index, ']');
                dataList.add(this.value.toString());
                this.heirarchyList.remove(this.heirarchyList.size() - 1);
            }
            ++arrayIndex;
            if (content.charAt(index) == ',' || content.charAt(index) == ']') continue;
            JSONUtility.handleFailure(this.heirarchyList, this.key, ", or ] is expected...@Position::", String.valueOf(index));
        } while (content.charAt(index) != ']');
        jsonData.put(tmpKey, dataList);
        if (skipCommaOrCurlyBrace && content.charAt(index = this.skipWhiteSpace(content, index + 1, ", or }")) != ',' && content.charAt(index) != '}') {
            JSONUtility.handleFailure(this.heirarchyList, this.key, ", or } is expected...@Position::", String.valueOf(index));
        }
        return index + 1;
    }

    private int determineTemplate(String valueType, String content, int index, char expected) {
        if (valueType == null || valueType.equals("STRING_LITERAL")) {
            index = this.stringLiteralTemplate(content, index, expected, true, this.value);
        } else if (valueType.equals("STRING")) {
            index = this.stringTemplate(content, index, expected, this.value);
        } else if (valueType.equals("INTEGER")) {
            index = this.numberTemplate(content, index, expected, false, this.value);
        } else if (valueType.equals("DOUBLE")) {
            index = this.numberTemplate(content, index, expected, true, this.value);
        } else if (valueType.equals("BOOLEAN")) {
            int tmpindex = index;
            index = this.stringTemplate(content, index, expected, this.value);
            String tmp = this.value.toString();
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Boolean value is expected...@Position::", String.valueOf(tmpindex));
            }
        } else if (valueType.equals("NULL")) {
            int tmpindex = index;
            index = this.stringTemplate(content, index, expected, this.value);
            String tmp = this.value.toString();
            if (!tmp.equalsIgnoreCase("NULL")) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Null is expected as value...@Position::", String.valueOf(tmpindex));
            }
        } else {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Unexpected value type is configured..." + valueType);
        }
        return index;
    }

    private int stringLiteralTemplate(String content, int index, char expected, boolean flag, StringBuilder temp) {
        int tempindex = index;
        boolean valueFound = false;
        if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf('\"'))) != '\"' && content.charAt(index) != '\'') {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Quote is expected...@Position::", String.valueOf(index));
        }
        char finalType = content.charAt(index);
        ++index;
        while (true) {
            if (index >= this.maxLength) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Quote/COMMA/" + expected + " is expected. Unexpected EOF...@Position::", String.valueOf(index));
            }
            if (content.charAt(index) != finalType) {
                temp.append(content.charAt(index++));
                valueFound = true;
                continue;
            }
            if (!this.backtraceToVerifyIfEscaped(content, index, '\\')) {
                if (content.charAt(index = this.skipWhiteSpace(content, index + 1, String.valueOf('+'))) == '+') {
                    index = this.stringLiteralTemplate(content, index + 1, expected, flag, temp);
                    return index;
                }
            } else {
                ++index;
                continue;
            }
            if (flag && content.charAt(index) == ',' || content.charAt(index) == expected) break;
            JSONUtility.handleFailure(this.heirarchyList, this.key, flag ? "COMMA or " : "", String.valueOf(expected), " is expected. but found ", String.valueOf(content.charAt(index)), "...@Position::", String.valueOf(index));
            ++index;
        }
        if (!valueFound) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, flag ? "Value" : "Key or Name", " is expected but found empty...@Position::", String.valueOf(index));
        }
        if (flag) {
            this.validateValue(tempindex, temp);
        }
        return index;
    }

    private int numberTemplate(String content, int index, char expected, boolean isDouble, StringBuilder temp) {
        int tempindex = index;
        boolean valueFound = false;
        boolean isDecimal = false;
        if (content.charAt(index = this.skipWhiteSpace(content, index, "VALUE_TOKEN")) == '-') {
            temp.append('-');
            index = this.skipWhiteSpace(content, index + 1, "VALUE_TOKEN");
        }
        while (true) {
            if (index >= this.maxLength) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "COMMA or ", String.valueOf(expected), " is expected. Unexpected EOF...@Position::", String.valueOf(index));
            }
            if (Character.isDigit(content.charAt(index))) {
                valueFound = true;
                temp.append(content.charAt(index++));
                continue;
            }
            if (content.charAt(index) != '.') break;
            if (isDecimal) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Decimal Point is not allowed multiple times in the number...@Position::", String.valueOf(index));
            }
            temp.append(content.charAt(index++));
            isDecimal = true;
        }
        char ch = content.charAt(index);
        if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf(','))) != ',' && content.charAt(index) != expected) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Illegal character '", String.valueOf(ch), "' is identified while parsing for NUMBER_TOKEN...@Position::", String.valueOf(index));
        }
        if (!valueFound) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Value is expected but found empty...@Position::", String.valueOf(index));
        }
        if (isDouble && !isDecimal) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "DOUBLE_NUM_TOKEN is expected.But found NUM_TOKEN...@Position::" + tempindex);
        }
        if (isDecimal && !isDouble) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "NUM_TOKEN is expected.But found DOUBLE_NUM_TOKEN...@Position::" + tempindex);
        }
        this.validateValue(tempindex, temp);
        return index;
    }

    private int stringTemplate(String content, int index, char expected, StringBuilder temp) {
        int tempindex = index;
        boolean valueFound = false;
        index = this.skipWhiteSpace(content, index, "VALUE_TOKEN");
        while (true) {
            if (!Character.isLetter(content.charAt(index)) && !Character.isDigit(content.charAt(index))) break;
            valueFound = true;
            temp.append(content.charAt(index));
            if (++index < this.maxLength) continue;
            JSONUtility.handleFailure(this.heirarchyList, this.key, "COMMA or '" + expected + "' is expected. Unexpected EOF...@Position::", String.valueOf(index));
        }
        char ch = content.charAt(index);
        index = this.skipWhiteSpace(content, index, String.valueOf(','));
        if (content.charAt(index) != ',' && content.charAt(index) != expected) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Illegal character '", String.valueOf(ch), "' is identified while parsing for STRING_TOKEN...@Position::", String.valueOf(index));
        }
        if (!valueFound) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Value is expected but found empty...@Position::", String.valueOf(index));
        }
        this.validateValue(tempindex, temp);
        return index;
    }

    private int nonValidatingValueTemplate(String content, int index, char expected, StringBuilder temp) {
        if (content.charAt(index = this.skipWhiteSpace(content, index, "VALUE_TOKEN")) == '\"' || content.charAt(index) == '\'') {
            return this.stringLiteralTemplate(content, index, expected, true, temp);
        }
        boolean valueFound = false;
        boolean isDotPresent = false;
        boolean isNumber = true;
        boolean isNegative = false;
        int tempindex = index;
        if (content.charAt(index) == '-') {
            isNegative = true;
            temp.append('-');
            index = this.skipWhiteSpace(content, index + 1, "VALUE_TOKEN");
        }
        while (true) {
            if (Character.isLetter(content.charAt(index))) {
                isNumber = false;
                valueFound = true;
                temp.append(content.charAt(index));
            } else if (Character.isDigit(content.charAt(index))) {
                valueFound = true;
                temp.append(content.charAt(index));
            } else {
                if (content.charAt(index) != '.') break;
                if (isDotPresent || !isNumber) {
                    JSONUtility.handleFailure(this.heirarchyList, this.key, "Invalid '.' is identified but not expected...@Position::", String.valueOf(index));
                }
                temp.append(content.charAt(index));
                isDotPresent = true;
            }
            if (++index < this.maxLength) continue;
            JSONUtility.handleFailure(this.heirarchyList, this.key, "COMMA or " + expected + " is expected. Unexpected EOF...@Position::", String.valueOf(index));
        }
        char ch = content.charAt(index);
        if (valueFound && !isNumber && isDotPresent) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Invalid VALUE_TOKEN...@Position::", String.valueOf(tempindex));
        }
        if (isNegative && !isNumber) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Invalid VALUE_TOKEN...@Position::", String.valueOf(tempindex));
        }
        if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf(','))) != ',' && content.charAt(index) != expected) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Illegal character '", String.valueOf(ch), "' is identified while parsing for VALUE_TOKEN...@Position::", String.valueOf(index));
        }
        if (!valueFound) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Value is expected but found empty...@Position::", String.valueOf(index));
        }
        return index;
    }

    private void validateValue(int index, StringBuilder temp) {
        if (!this.isValidating) {
            return;
        }
        String valueValidator = this.getPattern(this.key.toString(), "valueValidator");
        if (valueValidator != null) {
            SpecialValidator validator = CachedInstances.getInstance().getValidatorInstance(valueValidator);
            if (!validator.validate(temp.toString(), this.heirarchyList)) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Value validation failed...json-block::", this.jsonBlockName, "\tKey::", this.key.toString(), "\tValidator::", valueValidator);
            }
            return;
        }
        String valuePattern = this.getPattern(this.key.toString(), "valuePattern");
        if (valuePattern != null && !temp.toString().trim().matches(valuePattern)) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, temp.toString(), " is not matching the value pattern...@Position::", String.valueOf(index));
        }
    }

    private boolean backtraceToVerifyIfEscaped(String content, int index, char token) {
        int tmpindex = index;
        while (Character.isWhitespace(content.charAt(--tmpindex))) {
        }
        return content.charAt(tmpindex) == token;
    }

    private String getPattern(String key, String attribute) {
        HashMap<String, String> patternMap;
        String pattern;
        StringBuilder sb = new StringBuilder();
        for (String s : this.heirarchyList) {
            sb.append(s).append('/');
        }
        int index = sb.length() - 1;
        if (key.trim().equals("")) {
            if (sb.charAt(--index) == ']') {
                while (index > 0) {
                    if (sb.charAt(--index) != '[') continue;
                    --index;
                    break;
                }
            }
        } else {
            --index;
        }
        if ((pattern = (patternMap = this.configHandler.getPatternMap(sb.substring(0, index + 1))).get(key + "~~" + attribute)) == null) {
            pattern = patternMap.get("default~~" + attribute);
        }
        return pattern;
    }

    private int consumeJsonBodyStartToken(String content, int index) {
        if ((index = this.skipWhiteSpace(content, index, String.valueOf('{'))) >= this.maxLength) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "'{' is expected...@Position::", String.valueOf(index));
        }
        if (content.charAt(index) != '{') {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "'{' is expected, Found ", String.valueOf(content.charAt(index)), "...@Position::", String.valueOf(index));
        }
        this.tokenStack.push("{");
        return index + 1;
    }

    private void verifyIfPatternMatches(String token, String pattern) {
        if (!token.matches(pattern)) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "'", token, "' doesn't match with pattern '", pattern, "' ...");
        }
    }

    private int consumeExpectedWhiteSpace(String content, int index) {
        if (!Character.isWhitespace(content.charAt(index))) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Whitespace expected...@Position::", String.valueOf(index));
        }
        return this.skipWhiteSpace(content, index + 1, "Non-WhiteSpace");
    }

    private int consumeKeyOrName(String content, int index, StringBuilder temp, char token) {
        boolean isKeyFound = false;
        boolean underscore = false;
        if (content.charAt(index = this.skipWhiteSpace(content, index, "Key or Name")) == '\"' || content.charAt(index) == '\'') {
            index = this.stringLiteralTemplate(content, index, token, false, temp);
        } else {
            if (!Character.isLetterOrDigit(content.charAt(index)) && content.charAt(index) != '{') {
                ++index;
            }
            if (content.charAt(index) == '{') {
                temp.append("root");
                return index;
            }
            while (true) {
                if (index >= this.maxLength) {
                    JSONUtility.handleFailure(this.heirarchyList, this.key, String.valueOf(token), " is expected. Unexpected EOF...@Position::", String.valueOf(index));
                }
                if (Character.isLetterOrDigit(content.charAt(index))) {
                    temp.append(content.charAt(index));
                    underscore = false;
                    isKeyFound = true;
                } else {
                    if (content.charAt(index) != '_') break;
                    if (underscore) {
                        JSONUtility.handleFailure(this.heirarchyList, temp, "Two UNDERSCOREs are not allowed immediately in key/name...");
                    }
                    underscore = true;
                    temp.append('_');
                }
                ++index;
            }
            if (!isKeyFound) {
                JSONUtility.handleFailure(this.heirarchyList, temp, "Key/Name is expected...but found empty@Position::", String.valueOf(index));
            }
            if (content.charAt(index = this.skipWhiteSpace(content, index, String.valueOf(token))) != token) {
                JSONUtility.handleFailure(this.heirarchyList, temp, String.valueOf(token), " is expected...but found ", String.valueOf(content.charAt(index)), "@Position::", String.valueOf(index));
            }
        }
        return index + 1;
    }

    private int consumeVarDeclarationIfAny(String content, int index) {
        if (index + 2 >= this.maxLength) {
            JSONUtility.handleFailure(this.heirarchyList, this.key, "Unexpected End Of File while looking for var declaration...@Position::", String.valueOf(index));
        }
        if (content.substring(index, index + 3).equals("var") && Character.isWhitespace(content.charAt(index + 3))) {
            index = this.consumeExpectedWhiteSpace(content, index + 3);
        }
        return index;
    }

    private int skipWhiteSpace(String content, int index, String token) {
        while (true) {
            if (index >= this.maxLength) {
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Unexpected End Of File While looking for token '" + token + "' ...@Position::", String.valueOf(index));
            }
            if (!Character.isWhitespace(content.charAt(index))) {
                int tmpindex = index;
                if ((index = this.processCommentsIfAny(content, index, token)) <= tmpindex) break;
                continue;
            }
            ++index;
        }
        return index;
    }

    private int processCommentsIfAny(String content, int index, String token) {
        if (content.charAt(index) == '/') {
            int tmpindex = index;
            boolean isComments = false;
            boolean isMultiLineComment = false;
            while (true) {
                if (++index >= this.maxLength) {
                    JSONUtility.handleFailure(this.heirarchyList, this.key, "Unexpected End Of File While looking for token '", token, "' ...@Position::", String.valueOf(tmpindex));
                }
                if (isMultiLineComment) {
                    if (content.charAt(index) != '/' || !this.backtraceToVerifyIfEscaped(content, index, '*')) continue;
                    return index + 1;
                }
                if (isComments) {
                    if (content.charAt(index) != '\n') continue;
                    return index + 1;
                }
                if (Character.isWhitespace(content.charAt(index))) continue;
                if (content.charAt(index) == '/') {
                    isComments = true;
                    continue;
                }
                if (content.charAt(index) == '*') {
                    isMultiLineComment = true;
                    continue;
                }
                JSONUtility.handleFailure(this.heirarchyList, this.key, "Invalid Token '/' while parsing JSON...@Position::", String.valueOf(tmpindex));
            }
        }
        return index;
    }

    private int skipWhiteSpaceEOF(String content, int index) {
        while (true) {
            if (index >= this.maxLength) {
                return -1;
            }
            if (!Character.isWhitespace(content.charAt(index))) break;
            ++index;
        }
        return index;
    }
}

