/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.parsers;

import com.codesnippets4all.json.config.handlers.ConfigHandler;
import com.codesnippets4all.json.config.handlers.JsonConfigHandler;
import com.codesnippets4all.json.config.handlers.ValidationConfigType;
import com.codesnippets4all.json.config.handlers.XmlConfigHandler;
import com.codesnippets4all.json.parsers.JSONParser;
import com.codesnippets4all.json.types.CollectionTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JsonParserFactory {
    private static JsonParserFactory instance = null;

    private JsonParserFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonParserFactory getInstance() {
        if (instance != null) return instance;
        Class<JsonParserFactory> clazz = JsonParserFactory.class;
        synchronized (JsonParserFactory.class) {
            if (instance != null) return instance;
            instance = new JsonParserFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JSONParser newJsonParser() {
        JSONParser parser = new JSONParser();
        XmlConfigHandler configHandler = new XmlConfigHandler();
        parser.setConfigHandler(configHandler);
        return parser;
    }

    public JSONParser newJsonParser(ValidationConfigType type) {
        JSONParser parser = new JSONParser();
        ConfigHandler configHandler = null;
        switch (type) {
            case JSON: {
                configHandler = new JsonConfigHandler();
                break;
            }
            default: {
                configHandler = new XmlConfigHandler();
            }
        }
        configHandler.setParserSelfInstance(parser);
        parser.setConfigHandler(configHandler);
        parser.setCollectionTypes(new CollectionTypes(){

            public List getListType() {
                return new LinkedList();
            }

            public Map getMapType() {
                return new TreeMap();
            }
        });
        return parser;
    }

    public JSONParser newJsonParser(CollectionTypes collectionTypes) {
        JSONParser parser = this.newJsonParser();
        parser.setCollectionTypes(collectionTypes);
        return parser;
    }

    public JSONParser newJsonParser(ValidationConfigType type, CollectionTypes collectionTypes) {
        JSONParser parser = this.newJsonParser(type);
        parser.setCollectionTypes(collectionTypes);
        return parser;
    }
}

