/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.serializers;

import com.codesnippets4all.json.exceptions.SerializingException;
import com.codesnippets4all.json.generators.JSONGenerator;
import com.codesnippets4all.json.serializers.JsonSerializer;
import com.codesnippets4all.json.serializers.pojos.SerializerOptions;

public class ArraySerializer
implements JsonSerializer {
    public void serialize(Object toBeSerialized, StringBuilder serializedData, SerializerOptions options) {
        if (toBeSerialized == null) {
            throw new SerializingException("input object is null");
        }
        Class<?> clazz = toBeSerialized.getClass();
        if (!clazz.isArray()) {
            throw new SerializingException("input object is not an Array");
        }
        Class<?> c = clazz.getComponentType();
        serializedData.append('[');
        String type = c.getCanonicalName();
        boolean flag = true;
        if (c.isPrimitive()) {
            if (type.equals("int")) {
                for (int integer : (int[])toBeSerialized) {
                    serializedData.append(Integer.toString(integer)).append(',');
                }
            } else if (type.equals("short")) {
                for (short sh : (short[])toBeSerialized) {
                    serializedData.append(Short.toString(sh)).append(',');
                }
            } else if (type.equals("boolean")) {
                for (boolean bool : (boolean[])toBeSerialized) {
                    serializedData.append(bool).append(',');
                }
            } else if (type.equals("char")) {
                for (char ch : (char[])toBeSerialized) {
                    serializedData.append(ch).append(',');
                }
            } else if (type.equals("byte")) {
                for (byte b : (byte[])toBeSerialized) {
                    serializedData.append(Byte.toString(b)).append(',');
                }
            } else if (type.equals("long")) {
                for (long l : (long[])toBeSerialized) {
                    serializedData.append(Long.toString(l)).append(',');
                }
            } else if (type.equals("float")) {
                for (float f : (float[])toBeSerialized) {
                    serializedData.append(Float.toString(f)).append(',');
                }
            } else if (type.equals("double")) {
                for (double d : (double[])toBeSerialized) {
                    serializedData.append(Double.toString(d)).append(',');
                }
            } else {
                flag = false;
            }
        } else {
            for (Object obj : (Object[])toBeSerialized) {
                boolean isIterable = JSONGenerator.traverseObjects(obj, serializedData, false);
                if (isIterable) continue;
                serializedData.append(',');
            }
        }
        if (flag) {
            serializedData.deleteCharAt(serializedData.length() - 1);
        }
        serializedData.append(']');
    }
}

