/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.utils;

import com.codesnippets4all.json.exceptions.JSONConfigInitializationException;
import com.codesnippets4all.json.exceptions.JSONParsingException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtility {
    public static InputStream getStream(String classPathResource) {
        if (classPathResource == null || classPathResource.trim().equals("")) {
            throw new IllegalArgumentException("input configuration file path is null/empty...");
        }
        InputStream is = JSONUtility.class.getResourceAsStream(classPathResource);
        if (is == null) {
            is = JSONUtility.class.getClassLoader().getParent().getResourceAsStream(classPathResource);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classPathResource);
        }
        if (is == null) {
            throw new JSONConfigInitializationException("classpath resource cannot be loaded...");
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAndReadStream(String classPathResource, String encoding) {
        InputStream is = JSONUtility.getStream(classPathResource);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, Charset.forName(encoding)));
            String string = JSONUtility.readChunks(br, encoding);
            return string;
        }
        catch (Exception e) {
            new JSONParsingException("JSON Reading failed for classpath resource..." + classPathResource);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream is, String encoding) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, Charset.forName(encoding)));
            String string = JSONUtility.readChunks(br, encoding);
            return string;
        }
        catch (Exception e) {
            new JSONParsingException("Configuration Reading failed for stream..." + is);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public static String readChunks(BufferedReader br, String encoding) throws Exception {
        char[] charBuffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        int offset = -1;
        while ((offset = br.read(charBuffer)) > -1) {
            builder.append(charBuffer, 0, offset);
        }
        return builder.toString();
    }

    public static void handleFailure(List<String> heirarchyList, StringBuilder key, String ... strings) {
        StringBuilder sb = new StringBuilder();
        sb.append("@Key-Heirarchy::");
        for (String ele : heirarchyList) {
            sb.append(ele).append("/");
        }
        sb.append("\t@Key::");
        sb.append((CharSequence)key).append("\t");
        for (String string : strings) {
            sb.append(string);
        }
        throw new JSONParsingException(sb.toString());
    }
}

