/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.OwnerIdPolicy;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnector;
import java.time.Duration;

abstract class SherlockWithConnectorBuilder<T extends SherlockWithConnectorBuilder<?>> {
    private LockDuration duration = SherlockDefaults.DEFAULT_LOCK_DURATION;
    private OwnerIdPolicy ownerIdPolicy = SherlockDefaults.DEFAULT_OWNER_ID_POLICY;

    SherlockWithConnectorBuilder() {
    }

    public T withLockDuration(Duration duration) {
        this.duration = LockDuration.of((Duration)duration);
        return this.instance();
    }

    public T withOwnerId(String ownerId) {
        this.ownerIdPolicy = OwnerIdPolicy.staticOwnerIdPolicy((String)ownerId);
        return this.instance();
    }

    public T withUniqueOwnerId() {
        this.ownerIdPolicy = OwnerIdPolicy.uniqueOwnerIdPolicy();
        return this.instance();
    }

    public T withStaticUniqueOwnerId() {
        this.ownerIdPolicy = OwnerIdPolicy.staticUniqueOwnerIdPolicy();
        return this.instance();
    }

    public abstract Sherlock build();

    protected Sherlock build(DistributedLockConnector connector) {
        return new SherlockWithConnector(connector, this.ownerIdPolicy, this.duration);
    }

    private T instance() {
        return (T)this;
    }
}

