/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Preconditions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

final class MongoDistributedLock {
    static final Bson INDEX = Indexes.ascending((String[])new String[]{"_id", "acquiredBy", "acquiredAt"});
    static final IndexOptions INDEX_OPTIONS = new IndexOptions().background(true);
    private final LockId id;
    private final OwnerId ownerId;
    private final Instant acquiredAt;
    private final Instant expiresAt;

    static MongoDistributedLock fromDocument(Document document) {
        try {
            return new MongoDistributedLock(LockId.of((String)document.getString((Object)"_id")), OwnerId.of((String)document.getString((Object)"acquiredBy")), MongoDistributedLock.dateToInstant(document.getDate((Object)"acquiredAt")), MongoDistributedLock.dateToInstant(document.getDate((Object)"expiresAt")));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not deserialize lock document", exception);
        }
    }

    private static Instant dateToInstant(Date date) {
        return date != null ? MongoDistributedLock.truncateToMillis(date.toInstant()) : null;
    }

    private static Instant truncateToMillis(Instant instant) {
        return instant.truncatedTo(ChronoUnit.MILLIS);
    }

    static MongoDistributedLock fromLockRequest(LockRequest lockRequest, Instant acquiredAt) {
        Preconditions.expectNonNull((Object)lockRequest);
        Preconditions.expectNonNull((Object)acquiredAt);
        Instant releaseAt = Optional.ofNullable(lockRequest.getDuration()).map(LockDuration::getValue).map(acquiredAt::plus).map(MongoDistributedLock::truncateToMillis).orElse(null);
        return new MongoDistributedLock(lockRequest.getLockId(), lockRequest.getOwnerId(), MongoDistributedLock.truncateToMillis(acquiredAt), releaseAt);
    }

    private MongoDistributedLock(LockId id, OwnerId ownerId, Instant createdAt, Instant expiresAt) {
        this.id = (LockId)Preconditions.expectNonNull((Object)id);
        this.ownerId = (OwnerId)Preconditions.expectNonNull((Object)ownerId);
        this.acquiredAt = (Instant)Preconditions.expectNonNull((Object)createdAt);
        this.expiresAt = expiresAt;
    }

    Document toDocument() {
        Document result = new Document().append("_id", (Object)this.id.getValue()).append("acquiredBy", (Object)this.ownerId.getValue()).append("acquiredAt", (Object)this.acquiredAt);
        if (this.expiresAt != null) {
            result = result.append("expiresAt", (Object)this.expiresAt);
        }
        return result;
    }

    boolean hasSameOwner(Document document) {
        if (document == null) {
            return false;
        }
        MongoDistributedLock other = MongoDistributedLock.fromDocument(document);
        return this.ownerId.equals((Object)other.ownerId);
    }

    boolean isActive(Instant now) {
        return this.expiresAt == null || this.expiresAt.isAfter(now);
    }

    public String toString() {
        return "MongoDistributedLock{id=" + this.id + ", ownerId=" + this.ownerId + ", acquiredAt=" + this.acquiredAt + ", expiresAt=" + this.expiresAt + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoDistributedLock that = (MongoDistributedLock)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.ownerId, that.ownerId) && Objects.equals(this.acquiredAt, that.acquiredAt) && Objects.equals(this.expiresAt, that.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ownerId, this.acquiredAt, this.expiresAt);
    }

    static interface Fields {
        public static final String LOCK_ID_FIELD = "_id";
        public static final String ACQUIRED_BY_FIELD = "acquiredBy";
        public static final String ACQUIRED_AT_FIELD = "acquiredAt";
        public static final String EXPIRES_AT_FIELD = "expiresAt";
    }
}

