/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.MongoDistributedLockConnector;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.mongodb.client.MongoCollection;
import java.time.Clock;
import org.bson.Document;

public final class MongoSherlockBuilder
extends SherlockWithConnectorBuilder<MongoSherlockBuilder> {
    private MongoCollection<Document> collection;
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;

    public static MongoSherlockBuilder mongoSherlock() {
        return new MongoSherlockBuilder();
    }

    public static Sherlock mongoSherlock(MongoCollection<Document> collection) {
        return MongoSherlockBuilder.mongoSherlock().withLocksCollection(collection).build();
    }

    private MongoSherlockBuilder() {
    }

    public MongoSherlockBuilder withLocksCollection(MongoCollection<Document> collection) {
        this.collection = (MongoCollection)Preconditions.expectNonNull(collection, (String)"Expected non null collection");
        return this;
    }

    public MongoSherlockBuilder withClock(Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        return this;
    }

    public Sherlock build() {
        Preconditions.expectNonNull(this.collection, (String)"Expected non null collection");
        MongoDistributedLockConnector connector = new MongoDistributedLockConnector(this.collection, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

