/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf_extras;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.StandardModelFactory;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IText;
import org.thymeleaf.processor.element.AbstractAttributeModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

abstract class AbstractTextModifierProcessor
extends AbstractAttributeModelProcessor {
    private final TemplateMode templateMode;

    protected AbstractTextModifierProcessor(TemplateMode templateMode, String dialectPrefix, String attributeName, int precedence) {
        super(templateMode, dialectPrefix, null, false, attributeName, true, precedence, true);
        this.templateMode = templateMode;
    }

    protected void doProcess(ITemplateContext context, IModel model, AttributeName attributeName, String attributeValue, IElementModelStructureHandler structureHandler) {
        this.doProcess(model, this.getAttributeValueAsEvent(context, attributeValue));
    }

    abstract void doProcess(IModel var1, IText var2);

    private IText getAttributeValueAsEvent(ITemplateContext context, String attributeValue) {
        String evaluatedAttributeValue = this.getEvaluatedAttributeValue(context, attributeValue);
        IModelFactory modelFactory = this.getModelFactory(context);
        return modelFactory.createText((CharSequence)evaluatedAttributeValue);
    }

    private String getEvaluatedAttributeValue(ITemplateContext context, String attributeValue) {
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)context.getConfiguration());
        IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)context, attributeValue);
        Object execute = expression.execute((IExpressionContext)context);
        return execute == null ? "" : execute.toString();
    }

    private IModelFactory getModelFactory(ITemplateContext context) {
        return new StandardModelFactory(context.getConfiguration(), this.templateMode);
    }
}

