/*
 * Decompiled with CFR 0.152.
 */
package com.connect_group.thymeleaf_extras;

import com.connect_group.thymeleaf_extras.AbstractTextModifierProcessor;
import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.templatemode.TemplateMode;

final class StripWhiteSpaceHTMLProcessor
extends AbstractTextModifierProcessor {
    private static final String ATTRIBUTE_NAME = "strip-whitespace";
    private static final String DEEP_ATTRIBUTE_VALUE = "deep";

    protected StripWhiteSpaceHTMLProcessor(String dialectPrefix, int precedence) {
        super(TemplateMode.HTML, dialectPrefix, ATTRIBUTE_NAME, precedence);
    }

    @Override
    void doProcess(IModel model, IText attributeValue) {
        List<ITemplateEvent> validEvents = DEEP_ATTRIBUTE_VALUE.equals(attributeValue.getText()) ? this.getNonWhiteSpaceEvents(model, false) : this.getNonWhiteSpaceEvents(model, true);
        this.updateModel(model, validEvents);
    }

    private void updateModel(IModel model, List<ITemplateEvent> nonWhiteSpaceEvents) {
        model.reset();
        for (ITemplateEvent nonWhiteSpaceEvent : nonWhiteSpaceEvents) {
            model.add(nonWhiteSpaceEvent);
        }
    }

    private List<ITemplateEvent> getNonWhiteSpaceEvents(IModel model, boolean keepChildWhiteSpace) {
        ArrayList<ITemplateEvent> eventsToKeep = new ArrayList<ITemplateEvent>();
        int openElementCount = 0;
        for (int i = 0; i < model.size(); ++i) {
            ITemplateEvent iTemplateEvent = model.get(i);
            if (iTemplateEvent instanceof IOpenElementTag) {
                ++openElementCount;
            }
            if (iTemplateEvent instanceof ICloseElementTag) {
                --openElementCount;
            }
            if (!this.isNotText(iTemplateEvent) && !this.isNotWhiteSpace((IText)iTemplateEvent) && !this.keepChildWhiteSpace(openElementCount, keepChildWhiteSpace)) continue;
            eventsToKeep.add(iTemplateEvent);
        }
        return eventsToKeep;
    }

    private boolean keepChildWhiteSpace(int elementCount, boolean keepChildEmptyText) {
        return keepChildEmptyText && elementCount > 1;
    }

    private boolean isNotWhiteSpace(IText iTemplateEvent) {
        return !EngineEventUtils.isWhitespace((IText)iTemplateEvent);
    }

    private boolean isNotText(ITemplateEvent iTemplateEvent) {
        return !(iTemplateEvent instanceof IText);
    }
}

