/*
 * Copyright 2006-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.consol.citrus.config.xml;

import com.consol.citrus.endpoint.adapter.StaticResponseEndpointAdapter;
import com.consol.citrus.message.MessageHeaderType;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

import java.util.*;

/**
 * Endpoint adapter parser configures bean definition for static response producing component.
 * @author Christoph Deppisch
 * @since 1.4
 */
public class StaticResponseEndpointAdapterParser extends AbstractBeanDefinitionParser {

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticResponseEndpointAdapter.class);

        Element payloadData = DomUtils.getChildElementByTagName(element, "payload");
        if (payloadData != null) {
            builder.addPropertyValue("messagePayload", DomUtils.getTextValue(payloadData));
        }

        Element payloadResource = DomUtils.getChildElementByTagName(element, "resource");
        if (payloadResource != null) {
            builder.addPropertyValue("messagePayloadResource", payloadResource.getAttribute("file"));
            if (payloadResource.hasAttribute("charset")) {
                builder.addPropertyValue("messagePayloadResourceCharset", payloadResource.getAttribute("charset"));
            }
        }

        Element headerElement = DomUtils.getChildElementByTagName(element, "header");
        if (headerElement != null) {
            Map<String, Object> messageHeaders = new HashMap<String, Object>();

            List<?> elements = DomUtils.getChildElementsByTagName(headerElement, "element");
            for (Iterator<?> iter = elements.iterator(); iter.hasNext();) {
                Element headerValue = (Element) iter.next();

                String name = headerValue.getAttribute("name");
                String value = headerValue.getAttribute("value");
                String type = headerValue.getAttribute("type");

                if (StringUtils.hasText(type)) {
                    value = MessageHeaderType.createTypedValue(type, value);
                }

                messageHeaders.put(name, value);
            }

            builder.addPropertyValue("messageHeader", messageHeaders);

        }

        return builder.getBeanDefinition();
    }
}
