/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.client.HttpErrorPropagatingException;
import com.consol.citrus.http.interceptor.LoggingClientInterceptor;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.ReplyConsumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public class HttpClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(HttpClient.class);
    private CorrelationManager<Message> correlationManager;

    public HttpClient() {
        this(new HttpEndpointConfiguration());
    }

    public HttpClient(HttpEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return (HttpEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.getEndpointConfiguration().getClientInterceptors())) {
            LoggingClientInterceptor loggingClientInterceptor = new LoggingClientInterceptor();
            loggingClientInterceptor.setMessageListener(context.getMessageListeners());
            this.getEndpointConfiguration().setClientInterceptors(Arrays.asList(loggingClientInterceptor));
        }
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey((Message)httpMessage);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String endpointUri = this.getEndpointConfiguration().getEndpointUriResolver() != null ? this.getEndpointConfiguration().getEndpointUriResolver().resolveEndpointUri((Message)httpMessage, this.getEndpointConfiguration().getRequestUrl()) : this.getEndpointConfiguration().getRequestUrl();
        if (log.isDebugEnabled()) {
            log.debug("Sending HTTP message to: '" + endpointUri + "'");
            log.debug("Message to send:\n" + (String)httpMessage.getPayload(String.class));
        }
        HttpMethod method = this.getEndpointConfiguration().getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        HttpEntity requestEntity = this.getEndpointConfiguration().getMessageConverter().convertOutbound((Message)httpMessage, this.getEndpointConfiguration(), context);
        try {
            ResponseEntity response = this.getEndpointConfiguration().getRestTemplate().exchange(endpointUri, method, requestEntity, String.class, new Object[0]);
            log.info("HTTP message was sent to endpoint: '" + endpointUri + "'");
            this.correlationManager.store(correlationKey, (Object)this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity)response, this.getEndpointConfiguration(), context));
        }
        catch (HttpErrorPropagatingException e) {
            log.info("Caught HTTP rest client exception: " + e.getMessage());
            log.info("Propagating HTTP rest client exception according to error handling strategy");
            HttpMessage responseMessage = this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity)new ResponseEntity((Object)e.getResponseBodyAsString(), (MultiValueMap)e.getResponseHeaders(), e.getStatusCode()), this.getEndpointConfiguration(), context);
            this.correlationManager.store(correlationKey, (Object)responseMessage);
        }
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new ActionTimeoutException("Action timeout while receiving synchronous reply message from http server");
        }
        return message;
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

