/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.client.HttpErrorPropagatingException;
import com.consol.citrus.message.ErrorHandlingStrategy;
import java.io.IOException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class HttpResponseErrorHandler
extends DefaultResponseErrorHandler {
    private final ErrorHandlingStrategy errorHandlingStrategy;

    public HttpResponseErrorHandler(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        if (this.errorHandlingStrategy.equals((Object)ErrorHandlingStrategy.PROPAGATE)) {
            throw new HttpErrorPropagatingException(this.getHttpStatusCode(response), response.getStatusText(), response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
        }
        if (!this.errorHandlingStrategy.equals((Object)ErrorHandlingStrategy.THROWS_EXCEPTION)) {
            throw new CitrusRuntimeException("Unsupported error strategy: " + this.errorHandlingStrategy);
        }
        super.handleError(response);
    }
}

