/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.ReceiveMessageActionParser;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import java.util.List;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpReceiveResponseActionParser
extends ReceiveMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)("http:" + element.getLocalName()));
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("actor"), (String)"actor");
        String receiveTimeout = element.getAttribute("timeout");
        if (StringUtils.hasText((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)Long.valueOf(receiveTimeout));
        }
        if (!element.hasAttribute("uri") && !element.hasAttribute("client")) {
            throw new BeanCreationException("Neither http request uri nor http client endpoint reference is given - invalid test action definition");
        }
        if (element.hasAttribute("client")) {
            builder.addPropertyReference("endpoint", element.getAttribute("client"));
        } else if (element.hasAttribute("uri")) {
            builder.addPropertyValue("endpointUri", (Object)element.getAttribute("uri"));
        }
        HttpMessage httpMessage = new HttpMessage();
        Element headers = DomUtils.getChildElementByTagName((Element)element, (String)"headers");
        if (headers != null) {
            String version;
            String reasonPhrase;
            List headerElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"header");
            for (Object headerElement : headerElements) {
                Element header = (Element)headerElement;
                httpMessage.setHeader(header.getAttribute("name"), header.getAttribute("value"));
            }
            String statusCode = headers.getAttribute("status");
            if (StringUtils.hasText((String)statusCode)) {
                httpMessage.setHeader("citrus_http_status_code", statusCode);
            }
            if (StringUtils.hasText((String)(reasonPhrase = headers.getAttribute("reason-phrase")))) {
                httpMessage.reasonPhrase(reasonPhrase);
            }
            if (StringUtils.hasText((String)(version = headers.getAttribute("version")))) {
                httpMessage.version(version);
            }
            List cookieElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"cookie");
            for (Object item : cookieElements) {
                Element cookieElement = (Element)item;
                Cookie cookie = new Cookie(cookieElement.getAttribute("name"), cookieElement.getAttribute("value"));
                if (cookieElement.hasAttribute("comment")) {
                    cookie.setComment(cookieElement.getAttribute("comment"));
                }
                if (cookieElement.hasAttribute("path")) {
                    cookie.setPath(cookieElement.getAttribute("path"));
                }
                if (cookieElement.hasAttribute("domain")) {
                    cookie.setDomain(cookieElement.getAttribute("domain"));
                }
                if (cookieElement.hasAttribute("max-age")) {
                    cookie.setMaxAge(Integer.valueOf(cookieElement.getAttribute("max-age")).intValue());
                }
                if (cookieElement.hasAttribute("secure")) {
                    cookie.setSecure(Boolean.valueOf(cookieElement.getAttribute("secure")).booleanValue());
                }
                if (cookieElement.hasAttribute("version")) {
                    cookie.setVersion(Integer.valueOf(cookieElement.getAttribute("version")).intValue());
                }
                httpMessage.cookie(cookie);
            }
        }
        this.parseMessageSelector(element, builder);
        Element body = DomUtils.getChildElementByTagName((Element)element, (String)"body");
        List validationContexts = this.parseValidationContexts(body, builder);
        builder.addPropertyValue("messageBuilder", (Object)new HttpMessageContentBuilder(httpMessage, this.constructMessageBuilder(body)));
        builder.addPropertyValue("validationContexts", (Object)validationContexts);
        builder.addPropertyValue("variableExtractors", (Object)this.getVariableExtractors(element));
        return builder.getBeanDefinition();
    }
}

