/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.controller;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

@Controller
@RequestMapping(value={"/*"})
public class HttpMessageController {
    private EndpointAdapter endpointAdapter = new EmptyResponseEndpointAdapter();
    private HttpEndpointConfiguration endpointConfiguration = new HttpEndpointConfiguration();
    private ResponseEntity<String> responseCache;

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> handleGetRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.GET, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> handlePostRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.POST, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<String> handlePutRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PUT, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> handleDeleteRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.DELETE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.OPTIONS})
    @ResponseBody
    public ResponseEntity<String> handleOptionsRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.OPTIONS, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.HEAD})
    @ResponseBody
    public ResponseEntity<String> handleHeadRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.HEAD, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.TRACE})
    @ResponseBody
    public ResponseEntity<String> handleTraceRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.TRACE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PATCH})
    @ResponseBody
    public ResponseEntity<String> handlePatchRequest(HttpEntity<String> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PATCH, requestEntity);
    }

    private ResponseEntity<String> handleRequestInternal(HttpMethod method, HttpEntity<String> requestEntity) {
        String queryParams;
        HttpMessage request = this.endpointConfiguration.getMessageConverter().convertInbound(requestEntity, this.endpointConfiguration, null);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UrlPathHelper pathHelper = new UrlPathHelper();
        Enumeration allHeaders = servletRequest.getHeaderNames();
        for (String headerName : (String[])CollectionUtils.toArray((Enumeration)allHeaders, (Object[])new String[0])) {
            if (request.getHeader(headerName) != null) continue;
            String headerValue = servletRequest.getHeader(headerName);
            request.header(headerName, headerValue != null ? headerValue : "");
        }
        if (this.endpointConfiguration.isHandleCookies()) {
            request.setCookies(servletRequest.getCookies());
        }
        if (this.endpointConfiguration.isHandleAttributeHeaders()) {
            Enumeration attributeNames = servletRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attribute = servletRequest.getAttribute(attributeName);
                request.setHeader(attributeName, attribute);
            }
        }
        queryParams = (queryParams = pathHelper.getOriginatingQueryString(servletRequest)) == null ? "" : queryParams.replaceAll("&", ",");
        request.path(pathHelper.getRequestUri(servletRequest)).uri(pathHelper.getRequestUri(servletRequest)).contextPath(pathHelper.getContextPath(servletRequest)).queryParams(queryParams).version(servletRequest.getProtocol()).method(method);
        Message response = this.endpointAdapter.handleMessage((Message)request);
        if (response == null) {
            this.responseCache = new ResponseEntity(HttpStatus.OK);
        } else {
            HttpMessage httpResponse = response instanceof HttpMessage ? (HttpMessage)response : new HttpMessage(response);
            if (httpResponse.getStatusCode() == null) {
                httpResponse.status(HttpStatus.OK);
            }
            this.responseCache = (ResponseEntity)this.endpointConfiguration.getMessageConverter().convertOutbound((Message)httpResponse, this.endpointConfiguration, null);
            if (this.endpointConfiguration.isHandleCookies() && httpResponse.getCookies() != null) {
                HttpServletResponse servletResponse = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                for (Cookie cookie : httpResponse.getCookies()) {
                    servletResponse.addCookie(cookie);
                }
            }
        }
        return this.responseCache;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(HttpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public ResponseEntity<String> getResponseCache() {
        return this.responseCache;
    }
}

