/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class HttpMessage
extends DefaultMessage {
    private List<Cookie> cookies = new ArrayList<Cookie>();

    public HttpMessage() {
    }

    public HttpMessage(Message message) {
        super(message);
    }

    public HttpMessage(Object payload) {
        super(payload);
    }

    public HttpMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    public HttpMessage method(HttpMethod method) {
        this.setHeader("citrus_http_method", method.name());
        return this;
    }

    public HttpMessage version(String version) {
        this.setHeader("citrus_http_version", version);
        return this;
    }

    public HttpMessage status(HttpStatus statusCode) {
        this.statusCode(statusCode.value());
        this.reasonPhrase(statusCode.name());
        return this;
    }

    public HttpMessage statusCode(Integer statusCode) {
        this.setHeader("citrus_http_status_code", statusCode);
        return this;
    }

    public HttpMessage reasonPhrase(String reasonPhrase) {
        this.setHeader("citrus_http_reason_phrase", reasonPhrase);
        return this;
    }

    public HttpMessage uri(String requestUri) {
        this.setHeader("citrus_endpoint_uri", requestUri);
        this.setHeader("citrus_http_request_uri", requestUri);
        return this;
    }

    public HttpMessage contentType(String contentType) {
        this.setHeader("Content-Type", contentType);
        return this;
    }

    public HttpMessage accept(String accept) {
        this.setHeader("Accept", accept);
        return this;
    }

    public HttpMessage contextPath(String contextPath) {
        this.setHeader("citrus_http_context_path", contextPath);
        return this;
    }

    public HttpMessage queryParams(String queryParamString) {
        this.header("citrus_http_query_params", queryParamString);
        this.header("citrus_query_params", queryParamString);
        return this;
    }

    public HttpMessage queryParam(String name) {
        return this.queryParam(name, null);
    }

    public HttpMessage queryParam(String name, String value) {
        String queryParams;
        if (!StringUtils.hasText((String)name)) {
            throw new CitrusRuntimeException("Invalid query param name - must not be empty!");
        }
        if (this.getHeader("citrus_http_query_params") != null) {
            queryParams = this.getHeader("citrus_http_query_params").toString();
            queryParams = queryParams + "," + name + (StringUtils.hasText((String)value) ? "=" + value : "");
        } else {
            queryParams = name + (StringUtils.hasText((String)value) ? "=" + value : "");
        }
        this.header("citrus_http_query_params", queryParams);
        this.header("citrus_query_params", queryParams);
        return this;
    }

    public HttpMessage path(String path) {
        this.header("citrus_http_request_uri", path);
        this.header("citrus_request_path", path);
        return this;
    }

    public HttpMessage header(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMessage setHeader(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMethod getRequestMethod() {
        Object method = this.getHeader("citrus_http_method");
        if (method != null) {
            return HttpMethod.valueOf((String)method.toString());
        }
        return null;
    }

    public String getUri() {
        Object requestUri = this.getHeader("citrus_http_request_uri");
        if (requestUri != null) {
            return requestUri.toString();
        }
        return null;
    }

    public String getContextPath() {
        Object contextPath = this.getHeader("citrus_http_context_path");
        if (contextPath != null) {
            return contextPath.toString();
        }
        return null;
    }

    public String getQueryParams() {
        Object queryParams = this.getHeader("citrus_http_query_params");
        if (queryParams != null) {
            return queryParams.toString();
        }
        return null;
    }

    public HttpStatus getStatusCode() {
        Object statusCode = this.getHeader("citrus_http_status_code");
        if (statusCode != null) {
            if (statusCode instanceof HttpStatus) {
                return (HttpStatus)statusCode;
            }
            if (statusCode instanceof Integer) {
                return HttpStatus.valueOf((int)((Integer)statusCode));
            }
            return HttpStatus.valueOf((int)Integer.valueOf(statusCode.toString()));
        }
        return null;
    }

    public String getReasonPhrase() {
        Object reasonPhrase = this.getHeader("citrus_http_reason_phrase");
        if (reasonPhrase != null) {
            return reasonPhrase.toString();
        }
        return null;
    }

    public String getVersion() {
        Object version = this.getHeader("citrus_http_version");
        if (version != null) {
            return version.toString();
        }
        return null;
    }

    public String getPath() {
        Object path = this.getHeader("citrus_request_path");
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.cookie(cookie);
            }
        }
    }

    public HttpMessage cookie(Cookie cookie) {
        this.cookies.add(cookie);
        this.setHeader("citrus_http_cookie_" + cookie.getName(), this.getCookieString(cookie));
        return this;
    }

    private String getCookieString(Cookie cookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(cookie.getName());
        builder.append("=");
        builder.append(cookie.getValue());
        if (cookie.getVersion() > 0) {
            builder.append(";Version=").append(cookie.getVersion());
        }
        if (StringUtils.hasText((String)cookie.getPath())) {
            builder.append(";Path=").append(cookie.getPath());
        }
        if (StringUtils.hasText((String)cookie.getDomain())) {
            builder.append(";Domain=").append(cookie.getDomain());
        }
        if (cookie.getMaxAge() > 0) {
            builder.append(";Max-Age=").append(cookie.getMaxAge());
        }
        if (StringUtils.hasText((String)cookie.getComment())) {
            builder.append(";Comment=").append(cookie.getComment());
        }
        if (cookie.getSecure()) {
            builder.append(";Secure=").append(cookie.getSecure());
        }
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpMessage fromRequestData(String requestData) {
        try (BufferedReader reader = new BufferedReader(new StringReader(requestData));){
            HttpMessage request = new HttpMessage();
            String[] requestLine = reader.readLine().split("\\s");
            if (requestLine.length > 0) {
                request.method(HttpMethod.valueOf((String)requestLine[0]));
            }
            if (requestLine.length > 1) {
                request.uri(requestLine[1]);
            }
            if (requestLine.length > 2) {
                request.version(requestLine[2]);
            }
            String line = reader.readLine();
            while (StringUtils.hasText((String)line)) {
                if (!line.contains(":")) {
                    throw new CitrusRuntimeException(String.format("Invalid header syntax in line - expected 'key:value' but was '%s'", line));
                }
                String[] keyValue = line.split(":");
                request.setHeader(keyValue[0].trim(), keyValue[1].trim());
                line = reader.readLine();
            }
            StringBuilder bodyBuilder = new StringBuilder();
            line = reader.readLine();
            while (StringUtils.hasText((String)line)) {
                bodyBuilder.append(line).append(System.getProperty("line.separator"));
                line = reader.readLine();
            }
            request.setPayload(bodyBuilder.toString().trim());
            HttpMessage httpMessage = request;
            return httpMessage;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to parse Http raw request data", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpMessage fromResponseData(String responseData) {
        try (BufferedReader reader = new BufferedReader(new StringReader(responseData));){
            HttpMessage response = new HttpMessage();
            String[] statusLine = reader.readLine().split("\\s");
            if (statusLine.length > 0) {
                response.version(statusLine[0]);
            }
            if (statusLine.length > 1) {
                response.status(HttpStatus.valueOf((int)Integer.valueOf(statusLine[1])));
            }
            String line = reader.readLine();
            while (StringUtils.hasText((String)line)) {
                if (!line.contains(":")) {
                    throw new CitrusRuntimeException(String.format("Invalid header syntax in line - expected 'key:value' but was '%s'", line));
                }
                String[] keyValue = line.split(":");
                response.setHeader(keyValue[0].trim(), keyValue[1].trim());
                line = reader.readLine();
            }
            StringBuilder bodyBuilder = new StringBuilder();
            line = reader.readLine();
            while (StringUtils.hasText((String)line)) {
                bodyBuilder.append(line).append(System.getProperty("line.separator"));
                line = reader.readLine();
            }
            response.setPayload(bodyBuilder.toString().trim());
            HttpMessage httpMessage = response;
            return httpMessage;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to parse Http raw response data", (Throwable)e);
        }
    }
}

