/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

public class HttpMessageContentBuilder
extends AbstractMessageContentBuilder {
    private final HttpMessage message;
    private final AbstractMessageContentBuilder delegate;

    public HttpMessageContentBuilder(HttpMessage httpMessage, AbstractMessageContentBuilder delegate) {
        this.message = httpMessage;
        this.delegate = delegate;
    }

    public Message buildMessageContent(TestContext context, String messageType) {
        this.delegate.setMessageHeaders(this.message.getHeaders());
        Message delegateMessage = this.delegate.buildMessageContent(context, messageType);
        for (Map.Entry headerEntry : delegateMessage.getHeaders().entrySet()) {
            if (((String)headerEntry.getKey()).equals("citrus_message_id") || ((String)headerEntry.getKey()).equals("citrus_message_timestamp")) continue;
            this.message.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
        }
        this.message.setPayload(delegateMessage.getPayload());
        for (Cookie cookie : this.message.getCookies()) {
            if (cookie.getValue() != null) {
                cookie.setValue(context.replaceDynamicContentInString(cookie.getValue()));
            }
            if (cookie.getComment() != null) {
                cookie.setComment(context.replaceDynamicContentInString(cookie.getComment()));
            }
            if (cookie.getComment() != null) {
                cookie.setComment(context.replaceDynamicContentInString(cookie.getComment()));
            }
            if (cookie.getPath() != null) {
                cookie.setPath(context.replaceDynamicContentInString(cookie.getPath()));
            }
            if (cookie.getDomain() == null) continue;
            cookie.setDomain(context.replaceDynamicContentInString(cookie.getDomain()));
        }
        return this.message;
    }

    public DataDictionary getDataDictionary() {
        return this.delegate.getDataDictionary();
    }

    public List<MessageConstructionInterceptor> getMessageInterceptors() {
        return this.delegate.getMessageInterceptors();
    }

    public void setMessageInterceptors(List<MessageConstructionInterceptor> messageInterceptors) {
        this.delegate.setMessageInterceptors(messageInterceptors);
    }

    public String getMessageName() {
        return this.delegate.getMessageName();
    }

    public void setMessageName(String messageName) {
        this.delegate.setMessageName(messageName);
    }

    public void setMessageHeaders(Map<String, Object> messageHeaders) {
        this.delegate.setMessageHeaders(messageHeaders);
    }

    public List<String> getHeaderResources() {
        return this.delegate.getHeaderResources();
    }

    public void setHeaderResources(List<String> headerResources) {
        this.delegate.setHeaderResources(headerResources);
    }

    public List<String> getHeaderData() {
        return this.delegate.getHeaderData();
    }

    public void setHeaderData(List<String> headerData) {
        this.delegate.setHeaderData(headerData);
    }

    public Map<String, Object> getMessageHeaders() {
        return this.delegate.getMessageHeaders();
    }

    public Object buildMessagePayload(TestContext context, String messageType) {
        return this.delegate.buildMessagePayload(context, messageType);
    }

    public void add(MessageConstructionInterceptor interceptor) {
        this.delegate.add(interceptor);
    }

    public void setDataDictionary(DataDictionary dataDictionary) {
        this.delegate.setDataDictionary(dataDictionary);
    }

    public AbstractMessageContentBuilder getDelegate() {
        return this.delegate;
    }

    public HttpMessage getMessage() {
        return this.message;
    }
}

