/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.server;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.http.message.HttpMessageConverter;
import com.consol.citrus.http.server.HttpServer;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.web.servlet.HandlerInterceptor;

public class HttpServerBuilder
extends AbstractEndpointBuilder<HttpServer> {
    private HttpServer endpoint = new HttpServer();

    protected HttpServer getEndpoint() {
        return this.endpoint;
    }

    public HttpServerBuilder port(int port) {
        this.endpoint.setPort(port);
        return this;
    }

    public HttpServerBuilder autoStart(boolean autoStart) {
        this.endpoint.setAutoStart(autoStart);
        return this;
    }

    public HttpServerBuilder contextConfigLocation(String configLocation) {
        this.endpoint.setContextConfigLocation(configLocation);
        return this;
    }

    public HttpServerBuilder resourceBase(String resourceBase) {
        this.endpoint.setResourceBase(resourceBase);
        return this;
    }

    public HttpServerBuilder rootParentContext(boolean rootParentContext) {
        this.endpoint.setUseRootContextAsParent(rootParentContext);
        return this;
    }

    public HttpServerBuilder connectors(List<Connector> connectors) {
        this.endpoint.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        return this;
    }

    public HttpServerBuilder connector(Connector connector) {
        this.endpoint.setConnector(connector);
        return this;
    }

    public HttpServerBuilder filters(Map<String, Filter> filters) {
        this.endpoint.setFilters(filters);
        return this;
    }

    public HttpServerBuilder filterMappings(Map<String, String> filterMappings) {
        this.endpoint.setFilterMappings(filterMappings);
        return this;
    }

    public HttpServerBuilder servletName(String servletName) {
        this.endpoint.setServletName(servletName);
        return this;
    }

    public HttpServerBuilder servletMappingPath(String servletMappingPath) {
        this.endpoint.setServletMappingPath(servletMappingPath);
        return this;
    }

    public HttpServerBuilder contextPath(String contextPath) {
        this.endpoint.setContextPath(contextPath);
        return this;
    }

    public HttpServerBuilder servletHandler(ServletHandler servletHandler) {
        this.endpoint.setServletHandler(servletHandler);
        return this;
    }

    public HttpServerBuilder securityHandler(SecurityHandler securityHandler) {
        this.endpoint.setSecurityHandler(securityHandler);
        return this;
    }

    public HttpServerBuilder messageConverter(HttpMessageConverter messageConverter) {
        this.endpoint.setMessageConverter(messageConverter);
        return this;
    }

    public HttpServerBuilder handleAttributeHeaders(boolean flag) {
        this.endpoint.setHandleAttributeHeaders(flag);
        return this;
    }

    public HttpServerBuilder handleCookies(boolean flag) {
        this.endpoint.setHandleCookies(flag);
        return this;
    }

    public HttpServerBuilder timeout(long timeout) {
        this.endpoint.setDefaultTimeout(timeout);
        return this;
    }

    public HttpServerBuilder endpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpoint.setEndpointAdapter(endpointAdapter);
        return this;
    }

    public HttpServerBuilder interceptors(List<HandlerInterceptor> interceptors) {
        this.endpoint.setInterceptors(interceptors);
        return this;
    }
}

