/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.servlet;

import com.consol.citrus.Citrus;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class CachingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;

    public CachingHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String[]> getParameterMap() {
        if (this.body == null) {
            return super.getParameterMap();
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        if (RequestMethod.POST.name().equals(this.getMethod()) || RequestMethod.PUT.name().equals(this.getMethod())) {
            if (!"application/x-www-form-urlencoded".equals(this.getContentType())) return super.getParameterMap();
            this.fillParams(params, new String(this.body, Charset.forName(Citrus.CITRUS_FILE_ENCODING)));
            return params;
        } else {
            this.fillParams(params, this.getQueryString());
        }
        return params;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body == null) {
            this.body = super.getInputStream() != null ? FileCopyUtils.copyToByteArray((InputStream)super.getInputStream()) : new byte[0];
        }
        return new RequestCachingInputStream();
    }

    private void fillParams(Map<String, String[]> params, String queryString) {
        if (StringUtils.hasText((String)queryString)) {
            StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
            while (tokenizer.hasMoreTokens()) {
                String[] nameValuePair = tokenizer.nextToken().split("=");
                try {
                    params.put(URLDecoder.decode(nameValuePair[0], Citrus.CITRUS_FILE_ENCODING), new String[]{URLDecoder.decode(nameValuePair[1], Citrus.CITRUS_FILE_ENCODING)});
                }
                catch (UnsupportedEncodingException e) {
                    throw new CitrusRuntimeException(String.format("Failed to decode query param value '%s=%s'", nameValuePair[0], nameValuePair[1]), (Throwable)e);
                }
            }
        }
    }

    private final class RequestCachingInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream is;

        private RequestCachingInputStream() {
            this.is = new ByteArrayInputStream(CachingHttpServletRequestWrapper.this.body);
        }

        public boolean isFinished() {
            return this.is.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new CitrusRuntimeException("Unsupported operation");
        }

        public int read() throws IOException {
            return this.is.read();
        }
    }
}

