/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import javax.jms.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JmsProducer
implements Producer {
    private static Logger log = LoggerFactory.getLogger(JmsProducer.class);
    private final String name;
    private final JmsEndpointConfiguration endpointConfiguration;

    public JmsProducer(String name, JmsEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        if (this.endpointConfiguration.getDestination() != null) {
            this.send(message, this.endpointConfiguration.getDestination(), context);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
            if (this.endpointConfiguration.getDestinationNameResolver() != null) {
                this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationNameResolver().resolveEndpointUri(message, this.endpointConfiguration.getDestinationName())), context);
            } else {
                this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationName()), context);
            }
        } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null) {
            this.send(message, this.endpointConfiguration.getJmsTemplate().getDefaultDestination(), context);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
            this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName()), context);
        } else {
            throw new CitrusRuntimeException("Unable to send message - JMS destination not set");
        }
        context.onOutboundMessage(message);
    }

    private void send(Message message, String destinationName, TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Sending JMS message to destination: '" + destinationName + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(destinationName, session -> {
            javax.jms.Message jmsMessage = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, this.endpointConfiguration, context);
            return jmsMessage;
        });
        log.info("Message was sent to JMS destination: '" + destinationName + "'");
    }

    private void send(Message message, Destination destination, TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Sending JMS message to destination: '" + this.endpointConfiguration.getDestinationName(destination) + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(destination, session -> {
            javax.jms.Message jmsMessage = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, this.endpointConfiguration, context);
            return jmsMessage;
        });
        log.info("Message was sent to JMS destination: '" + this.endpointConfiguration.getDestinationName(destination) + "'");
    }

    public String getName() {
        return this.name;
    }
}

