/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="citrus.simulator")
public class SimulatorConfigurationProperties
implements EnvironmentAware {
    private static Logger log = LoggerFactory.getLogger(SimulatorConfigurationProperties.class);
    private static final String SIMULATOR_TEMPLATE_PATH_PROPERTY = "citrus.simulator.template.path";
    private static final String SIMULATOR_TEMPLATE_PATH_ENV = "CITRUS_SIMULATOR_TEMPLATE_PATH";
    private static final String SIMULATOR_SCENARIO_PROPERTY = "citrus.simulator.default.scenario";
    private static final String SIMULATOR_SCENARIO_ENV = "CITRUS_SIMULATOR_DEFAULT_SCENARIO";
    private static final String SIMULATOR_TIMEOUT_PROPERTY = "citrus.simulator.default.timeout";
    private static final String SIMULATOR_TIMEOUT_ENV = "CITRUS_SIMULATOR_DEFAULT_TIMEOUT";
    private static final String SIMULATOR_TEMPLATE_VALIDATION_PROPERTY = "citrus.simulator.template.validation";
    private static final String SIMULATOR_TEMPLATE_VALIDATION_ENV = "CITRUS_SIMULATOR_TEMPLATE_VALIDATION";
    private static final String SIMULATOR_EXCEPTION_DELAY_PROPERTY = "citrus.simulator.exception.delay";
    private static final String SIMULATOR_EXCEPTION_DELAY_ENV = "CITRUS_SIMULATOR_EXCEPTION_DELAY";
    private static final String SIMULATOR_INBOUND_XML_DICTIONARY_PROPERTY = "citrus.simulator.inbound.xml.dictionary";
    private static final String SIMULATOR_INBOUND_XML_DICTIONARY_ENV = "CITRUS_SIMULATOR_INBOUND_XML_DICTIONARY";
    private static final String SIMULATOR_OUTBOUND_XML_DICTIONARY_PROPERTY = "citrus.simulator.outbound.xml.dictionary";
    private static final String SIMULATOR_OUTBOUND_XML_DICTIONARY_ENV = "CITRUS_SIMULATOR_OUTBOUND_XML_DICTIONARY";
    private static final String SIMULATOR_INBOUND_JSON_DICTIONARY_PROPERTY = "citrus.simulator.inbound.json.dictionary";
    private static final String SIMULATOR_INBOUND_JSON_DICTIONARY_ENV = "CITRUS_SIMULATOR_INBOUND_JSON_DICTIONARY";
    private static final String SIMULATOR_OUTBOUND_JSON_DICTIONARY_PROPERTY = "citrus.simulator.outbound.json.dictionary";
    private static final String SIMULATOR_OUTBOUND_JSON_DICTIONARY_ENV = "CITRUS_SIMULATOR_OUTBOUND_JSON_DICTIONARY";
    private boolean enabled = true;
    private String templatePath = "com/consol/citrus/simulator/templates";
    private String defaultScenario = "DEFAULT_SCENARIO";
    private Long defaultTimeout = 5000L;
    private boolean templateValidation = true;
    private Long exceptionDelay = 5000L;
    private String inboundXmlDictionary = "inbound-xml-dictionary.xml";
    private String outboundXmlDictionary = "outbound-xml-dictionary.xml";
    private String inboundJsonDictionary = "inbound-json-dictionary.properties";
    private String outboundJsonDictionary = "outbound-json-dictionary.properties";
    private Environment env;

    @PostConstruct
    private void loadProperties() {
        this.templatePath = this.env.getProperty(SIMULATOR_TEMPLATE_PATH_PROPERTY, this.env.getProperty(SIMULATOR_TEMPLATE_PATH_ENV, this.templatePath));
        this.defaultScenario = this.env.getProperty(SIMULATOR_SCENARIO_PROPERTY, this.env.getProperty(SIMULATOR_SCENARIO_ENV, this.defaultScenario));
        this.defaultTimeout = Long.valueOf(this.env.getProperty(SIMULATOR_TIMEOUT_PROPERTY, this.env.getProperty(SIMULATOR_TIMEOUT_ENV, String.valueOf(this.defaultTimeout))));
        this.templateValidation = Boolean.valueOf(this.env.getProperty(SIMULATOR_TEMPLATE_VALIDATION_PROPERTY, this.env.getProperty(SIMULATOR_TEMPLATE_VALIDATION_ENV, String.valueOf(this.templateValidation))));
        this.exceptionDelay = Long.valueOf(this.env.getProperty(SIMULATOR_EXCEPTION_DELAY_PROPERTY, this.env.getProperty(SIMULATOR_EXCEPTION_DELAY_ENV, String.valueOf(this.exceptionDelay))));
        this.inboundXmlDictionary = this.env.getProperty(SIMULATOR_INBOUND_XML_DICTIONARY_PROPERTY, this.env.getProperty(SIMULATOR_INBOUND_XML_DICTIONARY_ENV, this.inboundXmlDictionary));
        this.outboundXmlDictionary = this.env.getProperty(SIMULATOR_OUTBOUND_XML_DICTIONARY_PROPERTY, this.env.getProperty(SIMULATOR_OUTBOUND_XML_DICTIONARY_ENV, this.outboundXmlDictionary));
        this.inboundJsonDictionary = this.env.getProperty(SIMULATOR_INBOUND_JSON_DICTIONARY_PROPERTY, this.env.getProperty(SIMULATOR_INBOUND_JSON_DICTIONARY_ENV, this.inboundJsonDictionary));
        this.outboundJsonDictionary = this.env.getProperty(SIMULATOR_OUTBOUND_JSON_DICTIONARY_PROPERTY, this.env.getProperty(SIMULATOR_OUTBOUND_JSON_DICTIONARY_ENV, this.outboundJsonDictionary));
        log.info("Using the simulator configuration: {}", (Object)this.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getDefaultScenario() {
        return this.defaultScenario;
    }

    public void setDefaultScenario(String defaultScenario) {
        this.defaultScenario = defaultScenario;
    }

    public boolean isTemplateValidation() {
        return this.templateValidation;
    }

    public void setTemplateValidation(boolean templateValidation) {
        this.templateValidation = templateValidation;
    }

    public void setDefaultTimeout(Long timout) {
        this.defaultTimeout = timout;
    }

    public Long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Long getExceptionDelay() {
        return this.exceptionDelay;
    }

    public void setExceptionDelay(Long exceptionDelay) {
        this.exceptionDelay = exceptionDelay;
    }

    public String getInboundXmlDictionary() {
        return this.inboundXmlDictionary;
    }

    public void setInboundXmlDictionary(String inboundXmlDictionary) {
        this.inboundXmlDictionary = inboundXmlDictionary;
    }

    public String getOutboundXmlDictionary() {
        return this.outboundXmlDictionary;
    }

    public void setOutboundXmlDictionary(String outboundXmlDictionary) {
        this.outboundXmlDictionary = outboundXmlDictionary;
    }

    public String getInboundJsonDictionary() {
        return this.inboundJsonDictionary;
    }

    public void setInboundJsonDictionary(String inboundJsonDictionary) {
        this.inboundJsonDictionary = inboundJsonDictionary;
    }

    public String getOutboundJsonDictionary() {
        return this.outboundJsonDictionary;
    }

    public void setOutboundJsonDictionary(String outboundJsonDictionary) {
        this.outboundJsonDictionary = outboundJsonDictionary;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled='" + this.enabled + '\'' + ", templatePath='" + this.templatePath + '\'' + ", defaultScenario='" + this.defaultScenario + '\'' + ", defaultTimeout=" + this.defaultTimeout + ", exceptionDelay=" + this.exceptionDelay + ", templateValidation=" + this.templateValidation + ", inboundXmlDictionary=" + this.inboundXmlDictionary + ", outboundXmlDictionary=" + this.outboundXmlDictionary + ", inboundJsonDictionary=" + this.inboundJsonDictionary + ", outboundJsonDictionary=" + this.outboundJsonDictionary + '}';
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

