/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.correlation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.correlation.CorrelationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CorrelationHandlerRegistry {
    private ConcurrentMap<CorrelationHandler, TestContext> registeredHandlers = new ConcurrentHashMap<CorrelationHandler, TestContext>();
    private int queueCapacity = 1000;

    public void register(CorrelationHandler handler, TestContext context) {
        if (!this.registeredHandlers.keySet().contains(handler)) {
            this.registeredHandlers.put(handler, context);
        }
        while (this.registeredHandlers.size() > this.queueCapacity) {
            Stream.of(this.registeredHandlers.keySet()).limit(this.queueCapacity / 10).collect(Collectors.toList()).parallelStream().forEach(toDelete -> {
                TestContext cfr_ignored_0 = (TestContext)this.registeredHandlers.remove(toDelete);
            });
        }
    }

    public void remove(CorrelationHandler handler) {
        this.registeredHandlers.remove(handler);
    }

    public CorrelationHandler findHandlerFor(Message request) {
        for (Map.Entry handlerEntry : this.registeredHandlers.entrySet()) {
            if (!((CorrelationHandler)handlerEntry.getKey()).isHandlerFor(request, (TestContext)handlerEntry.getValue())) continue;
            return (CorrelationHandler)handlerEntry.getKey();
        }
        return null;
    }
}

