/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.dictionary;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.variable.dictionary.xml.XpathMappingDataDictionary;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InboundXmlDataDictionary
extends XpathMappingDataDictionary {
    @Autowired
    public InboundXmlDataDictionary(SimulatorConfigurationProperties simulatorConfiguration) {
        this.setMappings(new LinkedHashMap());
        Resource inboundMappingFile = new PathMatchingResourcePatternResolver().getResource(simulatorConfiguration.getInboundXmlDictionary());
        if (inboundMappingFile.exists()) {
            this.mappingFile = inboundMappingFile;
        }
    }

    public <T> T translate(Node node, T value, TestContext context) {
        for (Map.Entry expressionEntry : this.mappings.entrySet()) {
            String expression = (String)expressionEntry.getKey();
            SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
            namespaceContext.setBindings(context.getNamespaceContextBuilder().getNamespaceMappings());
            NodeList findings = (NodeList)XPathUtils.evaluateExpression((Node)node.getOwnerDocument(), (String)expression, (NamespaceContext)namespaceContext, (QName)XPathConstants.NODESET);
            if (findings == null || !this.containsNode(findings, node)) continue;
            return (T)this.convertIfNecessary(context.replaceDynamicContentInString((String)expressionEntry.getValue()), value);
        }
        return value;
    }

    private boolean containsNode(NodeList findings, Node node) {
        for (int i = 0; i < findings.getLength(); ++i) {
            if (!findings.item(i).equals(node)) continue;
            return true;
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.mappings.put("//*[string-length(normalize-space(text())) > 0]", "@ignore@");
        this.mappings.put("//@*", "@ignore@");
    }
}

