/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.simulator.endpoint.EndpointConsumerInterceptor;
import com.consol.citrus.simulator.endpoint.EndpointProducerInterceptor;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EndpointAspect {
    private final EndpointConsumerInterceptor consumerInterceptor;
    private final EndpointProducerInterceptor producerInterceptor;

    public EndpointAspect(EndpointConsumerInterceptor consumerInterceptor, EndpointProducerInterceptor producerInterceptor) {
        this.consumerInterceptor = consumerInterceptor;
        this.producerInterceptor = producerInterceptor;
    }

    @Around(value="execution(* com.consol.citrus.endpoint.Endpoint.createConsumer(..))")
    public Object wrapConsumer(ProceedingJoinPoint joinPoint) throws Throwable {
        ProxyFactory proxyFactory = new ProxyFactory(joinPoint.proceed());
        proxyFactory.addAdvice((Advice)this.consumerInterceptor);
        return proxyFactory.getProxy();
    }

    @Around(value="execution(* com.consol.citrus.endpoint.Endpoint.createProducer(..))")
    public Object wrapProducer(ProceedingJoinPoint joinPoint) throws Throwable {
        ProxyFactory proxyFactory = new ProxyFactory(joinPoint.proceed());
        proxyFactory.addAdvice((Advice)this.producerInterceptor);
        return proxyFactory.getProxy();
    }
}

