/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.endpoint.EndpointMessageHandler;
import java.util.Arrays;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;

@Component
public class EndpointConsumerInterceptor
implements MethodInterceptor {
    private final EndpointMessageHandler endpointMessageHandler;

    public EndpointConsumerInterceptor(EndpointMessageHandler endpointMessageHandler) {
        this.endpointMessageHandler = endpointMessageHandler;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Optional<TestContext> testContext;
        Object result = methodInvocation.proceed();
        if (this.isReceiveMethod(methodInvocation) && (testContext = this.getTestContext(methodInvocation)).isPresent()) {
            Optional<Message> message = this.getMessage(result);
            message.ifPresent(msg -> this.endpointMessageHandler.handleReceivedMessage((Message)msg, (TestContext)testContext.get()));
        }
        return result;
    }

    private boolean isReceiveMethod(MethodInvocation methodInvocation) {
        return "receive".equals(methodInvocation.getMethod().getName());
    }

    private Optional<TestContext> getTestContext(MethodInvocation methodInvocation) {
        Object[] arguments = methodInvocation.getArguments();
        if (arguments != null) {
            return Arrays.stream(arguments).filter(TestContext.class::isInstance).map(TestContext.class::cast).findFirst();
        }
        return Optional.empty();
    }

    private Optional<Message> getMessage(Object result) {
        if (result != null && result instanceof Message) {
            return Optional.of((Message)result);
        }
        return Optional.empty();
    }
}

