/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.model.Message;
import com.consol.citrus.simulator.service.ActivityService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class EndpointMessageHandler {
    private static Logger LOG = LoggerFactory.getLogger(EndpointMessageHandler.class);
    private final ActivityService activityService;

    public EndpointMessageHandler(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void handleSentMessage(Message message, TestContext context) {
        this.saveScenarioMessage(message, context, Message.Direction.OUTBOUND);
    }

    public void handleReceivedMessage(Message message, TestContext context) {
        this.saveScenarioMessage(message, context, Message.Direction.INBOUND);
    }

    private void saveScenarioMessage(Message message, TestContext context, Message.Direction direction) {
        Optional<Long> executionId = this.extractExecutionId(context);
        Optional<String> citrusMessageId = this.extractCitrusMessageId(message);
        if (executionId.isPresent() && citrusMessageId.isPresent()) {
            this.activityService.saveScenarioMessage(executionId.get(), direction, (String)message.getPayload(String.class), citrusMessageId.get(), message.getHeaders());
        }
    }

    private Optional<Long> extractExecutionId(TestContext context) {
        String executionId;
        try {
            executionId = context.getVariable("scenarioExecutionId");
        }
        catch (CitrusRuntimeException e) {
            return Optional.empty();
        }
        try {
            if (StringUtils.hasText((String)executionId)) {
                return Optional.of(Long.parseLong(executionId));
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing the execution id. Was expection a Long", (Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<String> extractCitrusMessageId(Message message) {
        String stringHeaderValue;
        Object headerValue = message.getHeader("citrus_message_id");
        if (headerValue != null && headerValue instanceof String && StringUtils.hasText((String)(stringHeaderValue = (String)headerValue))) {
            return Optional.of(stringHeaderValue);
        }
        return Optional.empty();
    }
}

