/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.endpoint.adapter.RequestDispatchingEndpointAdapter;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.correlation.CorrelationHandler;
import com.consol.citrus.simulator.correlation.CorrelationHandlerRegistry;
import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.service.ScenarioExecutionService;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class SimulatorEndpointAdapter
extends RequestDispatchingEndpointAdapter
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SimulatorEndpointAdapter.class);
    @Autowired
    private CorrelationHandlerRegistry handlerRegistry;
    @Autowired
    private SimulatorConfigurationProperties configuration;
    @Autowired
    private ScenarioExecutionService scenarioExecutionService;
    private ApplicationContext applicationContext;
    private boolean handleResponse = true;

    protected Message handleMessageInternal(Message request) {
        CorrelationHandler handler = this.handlerRegistry.findHandlerFor(request);
        if (handler != null) {
            CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
            handler.getScenarioEndpoint().add(request, responseFuture);
            try {
                if (this.handleResponse) {
                    return responseFuture.get(this.configuration.getDefaultTimeout(), TimeUnit.MILLISECONDS);
                }
                return null;
            }
            catch (TimeoutException e) {
                LOG.warn(String.format("No response for scenario '%s'", handler.getScenarioEndpoint().getName()));
                return null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SimulatorException(e);
            }
            catch (ExecutionException e) {
                throw new SimulatorException(e);
            }
        }
        return super.handleMessageInternal(request);
    }

    public Message dispatchMessage(Message request, String mappingName) {
        SimulatorScenario scenario;
        String scenarioName = mappingName;
        CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
        if (StringUtils.hasText((String)scenarioName) && this.applicationContext.containsBean(scenarioName)) {
            scenario = (SimulatorScenario)this.applicationContext.getBean(scenarioName, SimulatorScenario.class);
        } else {
            scenarioName = this.configuration.getDefaultScenario();
            LOG.info("Unable to find scenario for mapping '{}' - using default scenario '{}'", (Object)mappingName, (Object)scenarioName);
            scenario = (SimulatorScenario)this.applicationContext.getBean(scenarioName, SimulatorScenario.class);
        }
        scenario.getScenarioEndpoint().setName(scenarioName);
        scenario.getScenarioEndpoint().add(request, responseFuture);
        this.scenarioExecutionService.run(scenario, scenarioName, Collections.emptyList());
        try {
            if (this.handleResponse) {
                return responseFuture.get(this.configuration.getDefaultTimeout(), TimeUnit.MILLISECONDS);
            }
            return null;
        }
        catch (TimeoutException e) {
            LOG.warn(String.format("No response for scenario '%s'", scenarioName));
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SimulatorException(e);
        }
        catch (ExecutionException e) {
            throw new SimulatorException(e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
    }

    public boolean isHandleResponse() {
        return this.handleResponse;
    }

    public void setHandleResponse(boolean handleResponse) {
        this.handleResponse = handleResponse;
    }
}

