/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.channel.ChannelSyncEndpoint;
import com.consol.citrus.channel.ChannelSyncEndpointConfiguration;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointAdapter;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointComponentConfigurer;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointPoller;
import com.consol.citrus.simulator.endpoint.SimulatorSoapEndpointPoller;
import com.consol.citrus.simulator.scenario.mapper.ContentBasedXPathScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@ConditionalOnProperty(prefix="citrus.simulator.endpoint", value={"enabled"}, havingValue="true")
public class SimulatorEndpointAutoConfiguration {
    @Autowired(required=false)
    private SimulatorEndpointComponentConfigurer configurer;
    @Autowired
    private SimulatorConfigurationProperties simulatorConfiguration;

    @Bean(name={"simulatorEndpoint"})
    protected Endpoint simulatorEndpoint(ApplicationContext applicationContext) {
        if (this.configurer != null) {
            return this.configurer.endpoint(applicationContext);
        }
        ChannelSyncEndpointConfiguration endpointConfiguration = new ChannelSyncEndpointConfiguration();
        ChannelSyncEndpoint syncEndpoint = new ChannelSyncEndpoint(endpointConfiguration);
        endpointConfiguration.setChannelName("simulator.inbound.endpoint");
        return syncEndpoint;
    }

    @Bean(name={"simulatorEndpointAdapter"})
    public SimulatorEndpointAdapter simulatorEndpointAdapter() {
        return new SimulatorEndpointAdapter();
    }

    @Bean(name={"simulatorScenarioMapper"})
    public ScenarioMapper simulatorScenarioMapper() {
        if (this.configurer != null) {
            return this.configurer.scenarioMapper();
        }
        return new ContentBasedXPathScenarioMapper().addXPathExpression("local-name(/*)");
    }

    @Bean(name={"simulatorEndpointPoller"})
    public SimulatorEndpointPoller endpointPoller(ApplicationContext applicationContext) {
        SimulatorEndpointPoller endpointPoller = this.configurer != null && this.configurer.useSoapEnvelope() ? new SimulatorSoapEndpointPoller() : new SimulatorEndpointPoller();
        endpointPoller.setInboundEndpoint(this.simulatorEndpoint(applicationContext));
        SimulatorEndpointAdapter endpointAdapter = this.simulatorEndpointAdapter();
        endpointAdapter.setApplicationContext(applicationContext);
        endpointAdapter.setMappingKeyExtractor(this.simulatorScenarioMapper());
        endpointAdapter.setFallbackEndpointAdapter(this.simulatorFallbackEndpointAdapter());
        endpointPoller.setExceptionDelay(this.exceptionDelay());
        endpointPoller.setEndpointAdapter((EndpointAdapter)endpointAdapter);
        return endpointPoller;
    }

    @Bean(name={"simulatorFallbackEndpointAdapter"})
    public EndpointAdapter simulatorFallbackEndpointAdapter() {
        if (this.configurer != null) {
            return this.configurer.fallbackEndpointAdapter();
        }
        return new EmptyResponseEndpointAdapter();
    }

    protected Long exceptionDelay() {
        if (this.configurer != null) {
            return this.configurer.exceptionDelay(this.simulatorConfiguration);
        }
        return this.simulatorConfiguration.getExceptionDelay();
    }
}

