/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.ReplyProducer;
import com.consol.citrus.simulator.exception.SimulatorException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class SimulatorEndpointPoller
implements InitializingBean,
Runnable,
DisposableBean,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SimulatorEndpointPoller.class);
    @Autowired
    private TestContextFactory testContextFactory;
    private Endpoint inboundEndpoint;
    private ExecutorService taskExecutor = Executors.newSingleThreadExecutor();
    private EndpointAdapter endpointAdapter;
    private CompletableFuture<Boolean> running = new CompletableFuture();
    private boolean autoStart = true;
    private long exceptionDelay = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Simulator endpoint waiting for requests on endpoint '{}'", (Object)this.inboundEndpoint.getName());
        long delay = 0L;
        while (this.running.getNow(true).booleanValue()) {
            try {
                Producer producer;
                if (delay > 0L) {
                    try {
                        if (!this.running.get(delay, TimeUnit.MILLISECONDS).booleanValue()) {
                            continue;
                        }
                    }
                    catch (TimeoutException e) {
                        LOG.info("Continue simulator endpoint polling after uncategorized exception");
                    }
                    finally {
                        delay = 0L;
                        continue;
                    }
                }
                TestContext context = this.testContextFactory.getObject();
                Message message = this.inboundEndpoint.createConsumer().receive(context, this.inboundEndpoint.getEndpointConfiguration().getTimeout());
                if (message == null) continue;
                LOG.debug("Processing inbound message '{}'", (Object)message.getId());
                Message response = this.endpointAdapter.handleMessage(this.processRequestMessage(message));
                if (response == null || !((producer = this.inboundEndpoint.createProducer()) instanceof ReplyProducer)) continue;
                LOG.debug("Sending response message for inbound message '{}'", (Object)message.getId());
                producer.send(this.processResponseMessage(response), context);
            }
            catch (ActionTimeoutException context) {
            }
            catch (CitrusRuntimeException | SimulatorException e) {
                LOG.error("Failed to process message: {}", (Object)e.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(e.getMessage(), e);
            }
            catch (Exception e) {
                delay = this.exceptionDelay;
                LOG.error("Unexpected error while processing: {}", (Object)e.getMessage());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Message processResponseMessage(Message response) {
        return response;
    }

    protected Message processRequestMessage(Message request) {
        return request;
    }

    public void start() {
        this.taskExecutor.execute(this);
    }

    public void stop() {
        LOG.info("Simulator endpoint poller terminating ...");
        this.running.complete(false);
        try {
            this.taskExecutor.awaitTermination(this.exceptionDelay, TimeUnit.MILLISECONDS);
            LOG.info("Simulator endpoint poller termination complete");
        }
        catch (InterruptedException e) {
            LOG.error("Error while waiting termination of endpoint poller", (Throwable)e);
        }
        finally {
            this.taskExecutor.shutdownNow();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.autoStart) {
            this.start();
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setInboundEndpoint(Endpoint inboundEndpoint) {
        this.inboundEndpoint = inboundEndpoint;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setExceptionDelay(long exceptionDelay) {
        this.exceptionDelay = exceptionDelay;
    }

    public long getExceptionDelay() {
        return this.exceptionDelay;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.stop();
    }
}

