/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.dsl.builder.HttpServerRequestActionBuilder;
import com.consol.citrus.dsl.builder.HttpServerResponseActionBuilder;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.scenario.AbstractSimulatorScenario;
import com.consol.citrus.simulator.scenario.ScenarioDesigner;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.json.JsonPathMappingDataDictionary;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CustomMatcher;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class HttpOperationScenario
extends AbstractSimulatorScenario {
    private final Operation operation;
    private final Map<String, Model> definitions;
    private final String path;
    private final HttpMethod method;
    private Response response;
    private HttpStatus statusCode = HttpStatus.OK;
    private JsonPathMappingDataDictionary inboundDataDictionary;
    private JsonPathMappingDataDictionary outboundDataDictionary;

    public HttpOperationScenario(String path, HttpMethod method, Operation operation, Map<String, Model> definitions) {
        this.operation = operation;
        this.definitions = definitions;
        this.path = path;
        this.method = method;
        if (operation.getResponses() != null) {
            this.response = (Response)operation.getResponses().get("200");
        }
    }

    @Override
    public void run(ScenarioDesigner scenario) {
        HttpServerRequestActionBuilder requestBuilder;
        scenario.name(this.operation.getOperationId());
        scenario.echo("Generated scenario from swagger operation: " + this.operation.getOperationId());
        switch (this.method) {
            case GET: {
                requestBuilder = scenario.http().receive().get();
                break;
            }
            case POST: {
                requestBuilder = scenario.http().receive().post();
                break;
            }
            case PUT: {
                requestBuilder = scenario.http().receive().put();
                break;
            }
            case HEAD: {
                requestBuilder = scenario.http().receive().head();
                break;
            }
            case DELETE: {
                requestBuilder = scenario.http().receive().delete();
                break;
            }
            default: {
                throw new SimulatorException("Unsupported request method: " + this.method.name());
            }
        }
        ((HttpServerRequestActionBuilder)requestBuilder.messageType(MessageType.JSON)).header("citrus_message_generated", (Object)true);
        requestBuilder.header("citrus_http_request_uri", (Object)new CustomMatcher<String>(String.format("request path matching %s", this.path)){

            public boolean matches(Object item) {
                return item instanceof String && new AntPathMatcher().match(HttpOperationScenario.this.path, (String)item);
            }
        });
        if (this.operation.getParameters() != null) {
            this.operation.getParameters().stream().filter(p -> p instanceof HeaderParameter).filter(Parameter::getRequired).forEach(p -> {
                HttpServerRequestActionBuilder cfr_ignored_0 = (HttpServerRequestActionBuilder)requestBuilder.header(p.getName(), (Object)this.createValidationExpression((AbstractSerializableParameter)((HeaderParameter)p)));
            });
            String queryParams = this.operation.getParameters().stream().filter(param -> param instanceof QueryParameter).filter(Parameter::getRequired).map(param -> "containsString(" + param.getName() + ")").collect(Collectors.joining(", "));
            if (StringUtils.hasText((String)queryParams)) {
                requestBuilder.header("citrus_http_query_params", (Object)("@assertThat(allOf(" + queryParams + "))@"));
            }
            this.operation.getParameters().stream().filter(p -> p instanceof BodyParameter).filter(Parameter::getRequired).forEach(p -> {
                HttpServerRequestActionBuilder cfr_ignored_0 = (HttpServerRequestActionBuilder)requestBuilder.payload(this.createValidationPayload((BodyParameter)p));
            });
            if (this.inboundDataDictionary != null) {
                requestBuilder.dictionary((DataDictionary)this.inboundDataDictionary);
            }
        }
        HttpServerResponseActionBuilder responseBuilder = ((HttpServerResponseActionBuilder)((HttpServerResponseActionBuilder)scenario.http().send().response(this.statusCode).messageType(MessageType.JSON)).header("citrus_message_generated", (Object)true)).contentType("application/json");
        if (this.response != null) {
            if (this.response.getHeaders() != null) {
                for (Map.Entry header : this.response.getHeaders().entrySet()) {
                    responseBuilder.header((String)header.getKey(), (Object)this.createRandomValue((Property)header.getValue(), false));
                }
            }
            if (this.response.getSchema() != null) {
                if (this.outboundDataDictionary != null && (this.response.getSchema() instanceof RefProperty || this.response.getSchema() instanceof ArrayProperty)) {
                    responseBuilder.dictionary((DataDictionary)this.outboundDataDictionary);
                }
                responseBuilder.payload(this.createRandomValue(this.response.getSchema(), false));
            }
        }
    }

    private String createRandomValue(Property property, boolean quotes) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            Model model = this.definitions.get(((RefProperty)property).getSimpleRef());
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createRandomValue((Property)entry.getValue(), true)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (property instanceof ArrayProperty) {
            payload.append("[");
            payload.append(this.createRandomValue(((ArrayProperty)property).getItems(), true));
            payload.append("]");
        } else if (property instanceof StringProperty || property instanceof DateProperty || property instanceof DateTimeProperty) {
            if (quotes) {
                payload.append("\"");
            }
            if (property instanceof DateProperty) {
                payload.append("citrus:currentDate()");
            } else if (property instanceof DateTimeProperty) {
                payload.append("citrus:currentDate('yyyy-MM-dd'T'hh:mm:ss')");
            } else if (!CollectionUtils.isEmpty((Collection)((StringProperty)property).getEnum())) {
                payload.append("citrus:randomEnumValue(").append(((StringProperty)property).getEnum().stream().map(value -> "'" + value + "'").collect(Collectors.joining(","))).append(")");
            } else {
                payload.append("citrus:randomString(").append(((StringProperty)property).getMaxLength() != null && ((StringProperty)property).getMaxLength() > 0 ? ((StringProperty)property).getMaxLength() : (((StringProperty)property).getMinLength() != null && ((StringProperty)property).getMinLength() > 0 ? ((StringProperty)property).getMinLength() : 10)).append(")");
            }
            if (quotes) {
                payload.append("\"");
            }
        } else if (property instanceof IntegerProperty || property instanceof LongProperty) {
            payload.append("citrus:randomNumber(10)");
        } else if (property instanceof FloatProperty || property instanceof DoubleProperty) {
            payload.append("citrus:randomNumber(10)");
        } else if (property instanceof BooleanProperty) {
            payload.append("citrus:randomEnumValue('true', 'false')");
        } else if (quotes) {
            payload.append("\"\"");
        } else {
            payload.append("");
        }
        return payload.toString();
    }

    private String createValidationPayload(BodyParameter parameter) {
        StringBuilder payload = new StringBuilder();
        Model model = parameter.getSchema();
        if (model instanceof RefModel) {
            model = this.definitions.get(((RefModel)model).getSimpleRef());
        }
        if (model instanceof ArrayModel) {
            payload.append("[");
            payload.append(this.createValidationExpression(((ArrayModel)model).getItems()));
            payload.append("]");
        } else {
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createValidationExpression((Property)entry.getValue())).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        }
        return payload.toString();
    }

    private String createValidationExpression(Property property) {
        StringBuilder payload = new StringBuilder();
        if (property instanceof RefProperty) {
            Model model = this.definitions.get(((RefProperty)property).getSimpleRef());
            payload.append("{");
            if (model.getProperties() != null) {
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(this.createValidationExpression((Property)entry.getValue())).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (property instanceof ArrayProperty) {
            payload.append("\"@ignore@\"");
        } else if (property instanceof StringProperty) {
            if (StringUtils.hasText((String)((StringProperty)property).getPattern())) {
                payload.append("\"@matches(").append(((StringProperty)property).getPattern()).append(")@\"");
            } else if (!CollectionUtils.isEmpty((Collection)((StringProperty)property).getEnum())) {
                payload.append("\"@matches(").append(((StringProperty)property).getEnum().stream().collect(Collectors.joining("|"))).append(")@\"");
            } else {
                payload.append("\"@notEmpty()@\"");
            }
        } else if (property instanceof DateProperty) {
            payload.append("\"@matchesDatePattern('yyyy-MM-dd')@\"");
        } else if (property instanceof DateTimeProperty) {
            payload.append("\"@matchesDatePattern('yyyy-MM-dd'T'hh:mm:ss')@\"");
        } else if (property instanceof IntegerProperty || property instanceof LongProperty) {
            payload.append("\"@isNumber()@\"");
        } else if (property instanceof FloatProperty || property instanceof DoubleProperty) {
            payload.append("\"@isNumber()@\"");
        } else if (property instanceof BooleanProperty) {
            payload.append("\"@matches(true|false)@\"");
        } else {
            payload.append("\"@ignore@\"");
        }
        return payload.toString();
    }

    private String createValidationExpression(AbstractSerializableParameter parameter) {
        switch (parameter.getType()) {
            case "integer": {
                return "@isNumber()@";
            }
            case "string": {
                if (parameter.getFormat() != null && parameter.getFormat().equals("date")) {
                    return "\"@matchesDatePattern('yyyy-MM-dd')@\"";
                }
                if (parameter.getFormat() != null && parameter.getFormat().equals("date-time")) {
                    return "\"@matchesDatePattern('yyyy-MM-dd'T'hh:mm:ss')@\"";
                }
                if (StringUtils.hasText((String)parameter.getPattern())) {
                    return "\"@matches(" + parameter.getPattern() + ")@\"";
                }
                if (!CollectionUtils.isEmpty((Collection)parameter.getEnum())) {
                    return "\"@matches(" + parameter.getEnum().stream().collect(Collectors.joining("|")) + ")@\"";
                }
                return "@notEmpty()@";
            }
            case "boolean": {
                return "@matches(true|false)@";
            }
        }
        return "@ignore@";
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public JsonPathMappingDataDictionary getInboundDataDictionary() {
        return this.inboundDataDictionary;
    }

    public void setInboundDataDictionary(JsonPathMappingDataDictionary inboundDataDictionary) {
        this.inboundDataDictionary = inboundDataDictionary;
    }

    public JsonPathMappingDataDictionary getOutboundDataDictionary() {
        return this.outboundDataDictionary;
    }

    public void setOutboundDataDictionary(JsonPathMappingDataDictionary outboundDataDictionary) {
        this.outboundDataDictionary = outboundDataDictionary;
    }
}

