/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.http.HttpOperationScenario;
import com.consol.citrus.simulator.http.HttpRequestAnnotationScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class HttpRequestPathScenarioMapper
extends HttpRequestAnnotationScenarioMapper
implements ScenarioMapper {
    @Autowired(required=false)
    private List<HttpOperationScenario> httpScenarios = new ArrayList<HttpOperationScenario>();
    private PathMatcher pathMatcher = new AntPathMatcher();

    @Override
    protected String getMappingKey(Message request) {
        String requestPath;
        if (request instanceof HttpMessage && (requestPath = ((HttpMessage)request).getPath()) != null) {
            for (HttpOperationScenario scenario : this.httpScenarios) {
                if (!scenario.getPath().equals(requestPath) || !scenario.getMethod().name().equals(((HttpMessage)request).getRequestMethod().name())) continue;
                return scenario.getOperation().getOperationId();
            }
            for (HttpOperationScenario scenario : this.httpScenarios) {
                if (!this.pathMatcher.match(scenario.getPath(), requestPath) || !scenario.getMethod().name().equals(((HttpMessage)request).getRequestMethod().name())) continue;
                return scenario.getOperation().getOperationId();
            }
        }
        return super.getMappingKey(request);
    }

    public List<HttpOperationScenario> getHttpScenarios() {
        return this.httpScenarios;
    }

    public void setHttpScenarios(List<HttpOperationScenario> httpScenarios) {
        this.httpScenarios = httpScenarios;
    }
}

