/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.http.HttpOperationScenario;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class HttpScenarioGenerator
implements BeanFactoryPostProcessor {
    private static Logger log = LoggerFactory.getLogger(HttpScenarioGenerator.class);
    private final Resource swaggerResource;
    private String contextPath = "";
    private static final String SIMULATOR_SWAGGER_API_PROPERTY = "citrus.simulator.rest.swagger.api";
    private static final String SIMULATOR_SWAGGER_API_ENV = "CITRUS_SIMULATOR_REST_SWAGGER_API";
    private static final String SIMULATOR_SWAGGER_CONTEXT_PATH_PROPERTY = "citrus.simulator.rest.swagger.contextPath";
    private static final String SIMULATOR_SWAGGER_CONTEXT_PATH_ENV = "CITRUS_SIMULATOR_REST_SWAGGER_CONTEXT_PATH";

    public HttpScenarioGenerator(Environment environment) {
        this.swaggerResource = new PathMatchingResourcePatternResolver().getResource(environment.getProperty(SIMULATOR_SWAGGER_API_PROPERTY, environment.getProperty(SIMULATOR_SWAGGER_API_ENV, "")));
        this.contextPath = environment.getProperty(SIMULATOR_SWAGGER_CONTEXT_PATH_PROPERTY, environment.getProperty(SIMULATOR_SWAGGER_CONTEXT_PATH_ENV, this.contextPath));
    }

    public HttpScenarioGenerator(Resource swaggerResource) {
        this.swaggerResource = swaggerResource;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            Assert.notNull((Object)this.swaggerResource, (String)"Missing either swagger api system property setting or explicit swagger api resource for scenario auto generation");
            Swagger swagger = new SwaggerParser().read(this.swaggerResource.getURI().toURL().toString());
            for (Map.Entry path : swagger.getPaths().entrySet()) {
                for (Map.Entry operation : ((Path)path.getValue()).getOperationMap().entrySet()) {
                    if (beanFactory instanceof BeanDefinitionRegistry) {
                        log.info("Register auto generated scenario as bean definition: " + ((Operation)operation.getValue()).getOperationId());
                        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(HttpOperationScenario.class).addConstructorArgValue((Object)(this.contextPath + (swagger.getBasePath() != null ? swagger.getBasePath() : "") + (String)path.getKey())).addConstructorArgValue((Object)HttpMethod.valueOf((String)((io.swagger.models.HttpMethod)operation.getKey()).name())).addConstructorArgValue(operation.getValue()).addConstructorArgValue((Object)swagger.getDefinitions());
                        if (beanFactory.containsBeanDefinition("inboundJsonDataDictionary")) {
                            beanDefinitionBuilder.addPropertyReference("inboundDataDictionary", "inboundJsonDataDictionary");
                        }
                        if (beanFactory.containsBeanDefinition("outboundJsonDataDictionary")) {
                            beanDefinitionBuilder.addPropertyReference("outboundDataDictionary", "outboundJsonDataDictionary");
                        }
                        ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(((Operation)operation.getValue()).getOperationId(), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
                        continue;
                    }
                    log.info("Register auto generated scenario as singleton: " + ((Operation)operation.getValue()).getOperationId());
                    beanFactory.registerSingleton(((Operation)operation.getValue()).getOperationId(), (Object)this.createScenario(this.contextPath + (swagger.getBasePath() != null ? swagger.getBasePath() : "") + (String)path.getKey(), HttpMethod.valueOf((String)((io.swagger.models.HttpMethod)operation.getKey()).name()), (Operation)operation.getValue(), swagger.getDefinitions()));
                }
            }
        }
        catch (IOException e) {
            throw new SimulatorException("Failed to read swagger api resource", e);
        }
    }

    protected HttpOperationScenario createScenario(String path, HttpMethod method, Operation operation, Map<String, Model> definitions) {
        return new HttpOperationScenario(path, method, operation, definitions);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

