/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.jms;

import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsSyncEndpoint;
import com.consol.citrus.jms.endpoint.JmsSyncEndpointConfiguration;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointAdapter;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointPoller;
import com.consol.citrus.simulator.endpoint.SimulatorSoapEndpointPoller;
import com.consol.citrus.simulator.jms.SimulatorJmsConfigurationProperties;
import com.consol.citrus.simulator.jms.SimulatorJmsConfigurer;
import com.consol.citrus.simulator.scenario.mapper.ContentBasedXPathScenarioMapper;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@EnableConfigurationProperties(value={SimulatorJmsConfigurationProperties.class})
@ConditionalOnProperty(prefix="citrus.simulator.jms", value={"enabled"}, havingValue="true")
public class SimulatorJmsAutoConfiguration {
    @Autowired(required=false)
    private SimulatorJmsConfigurer configurer;
    @Autowired
    private SimulatorJmsConfigurationProperties simulatorJmsConfiguration;
    @Autowired
    private SimulatorConfigurationProperties simulatorConfiguration;

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory connectionFactory() {
        if (this.configurer != null) {
            return this.configurer.connectionFactory();
        }
        return new SingleConnectionFactory();
    }

    @Bean(name={"simulatorJmsInboundEndpoint"})
    protected JmsEndpoint jmsInboundEndpoint(ConnectionFactory connectionFactory) {
        if (this.isSynchronous()) {
            JmsSyncEndpointConfiguration endpointConfiguration = new JmsSyncEndpointConfiguration();
            JmsSyncEndpoint jmsEndpoint = new JmsSyncEndpoint(endpointConfiguration);
            endpointConfiguration.setDestinationName(this.getInboundDestination());
            if (StringUtils.hasText((String)this.getReplyDestination())) {
                endpointConfiguration.setReplyDestinationName(this.getReplyDestination());
            }
            endpointConfiguration.setConnectionFactory(connectionFactory);
            return jmsEndpoint;
        }
        JmsEndpointConfiguration endpointConfiguration = new JmsEndpointConfiguration();
        JmsEndpoint jmsEndpoint = new JmsEndpoint(endpointConfiguration);
        endpointConfiguration.setDestinationName(this.getInboundDestination());
        endpointConfiguration.setConnectionFactory(connectionFactory);
        return jmsEndpoint;
    }

    @Bean(name={"simulatorJmsEndpointAdapter"})
    public SimulatorEndpointAdapter simulatorEndpointAdapter() {
        return new SimulatorEndpointAdapter();
    }

    @Bean(name={"simulatorJmsScenarioMapper"})
    public ScenarioMapper simulatorScenarioMapper() {
        if (this.configurer != null) {
            return this.configurer.scenarioMapper();
        }
        return new ContentBasedXPathScenarioMapper().addXPathExpression("local-name(/*)");
    }

    @Bean(name={"simulatorJmsEndpointPoller"})
    public SimulatorEndpointPoller endpointPoller(ApplicationContext applicationContext, ConnectionFactory connectionFactory) {
        SimulatorEndpointPoller endpointPoller = this.useSoap() ? new SimulatorSoapEndpointPoller() : new SimulatorEndpointPoller();
        endpointPoller.setInboundEndpoint((Endpoint)this.jmsInboundEndpoint(connectionFactory));
        SimulatorEndpointAdapter endpointAdapter = this.simulatorEndpointAdapter();
        endpointAdapter.setApplicationContext(applicationContext);
        endpointAdapter.setMappingKeyExtractor(this.simulatorScenarioMapper());
        endpointAdapter.setFallbackEndpointAdapter(this.simulatorFallbackEndpointAdapter());
        if (!this.isSynchronous()) {
            endpointAdapter.setHandleResponse(false);
        }
        endpointPoller.setExceptionDelay(this.exceptionDelay(this.simulatorConfiguration));
        endpointPoller.setEndpointAdapter((EndpointAdapter)endpointAdapter);
        return endpointPoller;
    }

    @Bean(name={"simulatorJmsFallbackEndpointAdapter"})
    public EndpointAdapter simulatorFallbackEndpointAdapter() {
        if (this.configurer != null) {
            return this.configurer.fallbackEndpointAdapter();
        }
        return new EmptyResponseEndpointAdapter();
    }

    protected String getInboundDestination() {
        if (this.configurer != null) {
            return this.configurer.inboundDestination(this.simulatorJmsConfiguration);
        }
        return this.simulatorJmsConfiguration.getInboundDestination();
    }

    protected String getReplyDestination() {
        if (this.configurer != null) {
            return this.configurer.replyDestination(this.simulatorJmsConfiguration);
        }
        return this.simulatorJmsConfiguration.getReplyDestination();
    }

    protected boolean isSynchronous() {
        if (this.configurer != null) {
            return this.configurer.synchronous(this.simulatorJmsConfiguration);
        }
        return this.simulatorJmsConfiguration.isSynchronous();
    }

    protected boolean useSoap() {
        if (this.configurer != null) {
            return this.configurer.useSoap(this.simulatorJmsConfiguration);
        }
        return this.simulatorJmsConfiguration.isUseSoap();
    }

    protected Long exceptionDelay(SimulatorConfigurationProperties simulatorConfiguration) {
        if (this.configurer != null) {
            return this.configurer.exceptionDelay(simulatorConfiguration);
        }
        return simulatorConfiguration.getExceptionDelay();
    }
}

