/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.listener;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.MessageListeners;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimulatorMessageListener
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimulatorMessageListener.class);
    @Autowired
    private MessageListeners messageListeners;

    @PostConstruct
    public void init() {
        this.messageListeners.addMessageListener((MessageListener)this);
    }

    public void onInboundMessage(Message message, TestContext context) {
        String payload = (String)message.getPayload(String.class);
        LOG.debug("received: {}", (Object)payload);
    }

    public void onOutboundMessage(Message message, TestContext context) {
        String payload = (String)message.getPayload(String.class);
        LOG.debug("sent: {}", (Object)payload);
    }
}

