/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.listener;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.actions.SleepAction;
import com.consol.citrus.report.AbstractTestListener;
import com.consol.citrus.report.TestActionListener;
import com.consol.citrus.report.TestResults;
import com.consol.citrus.simulator.service.ActivityService;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SimulatorStatusListener
extends AbstractTestListener
implements TestActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimulatorStatusListener.class);
    private Map<String, TestResult> runningTests = new ConcurrentHashMap<String, TestResult>();
    private TestResults testResults = new TestResults();
    @Autowired
    protected ActivityService executionService;

    public void onTestStart(TestCase test) {
        this.runningTests.put(StringUtils.arrayToCommaDelimitedString((Object[])this.getParameters(test)), TestResult.success((String)test.getName(), (Map)test.getParameters()));
    }

    public void onTestFinish(TestCase test) {
        this.runningTests.remove(StringUtils.arrayToCommaDelimitedString((Object[])this.getParameters(test)));
    }

    public void onTestSuccess(TestCase test) {
        TestResult result = TestResult.success((String)test.getName(), (Map)test.getParameters());
        this.testResults.addResult(result);
        LOG.info(result.toString());
        this.executionService.completeScenarioExecutionSuccess(test);
    }

    public void onTestFailure(TestCase test, Throwable cause) {
        TestResult result = TestResult.failed((String)test.getName(), (Throwable)cause, (Map)test.getParameters());
        this.testResults.addResult(result);
        LOG.info(result.toString());
        LOG.info(result.getFailureCause());
        this.executionService.completeScenarioExecutionFailure(test, cause);
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        if (!this.ignoreTestAction(testAction)) {
            LOG.debug(testCase.getName() + "(" + StringUtils.arrayToCommaDelimitedString((Object[])this.getParameters(testCase)) + ") - " + testAction.getName() + ": " + (StringUtils.hasText((String)testAction.getDescription()) ? testAction.getDescription() : ""));
            this.executionService.createTestAction(testCase, testAction);
        }
    }

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        if (!this.ignoreTestAction(testAction)) {
            this.executionService.completeTestAction(testCase, testAction);
        }
    }

    private boolean ignoreTestAction(TestAction testAction) {
        return testAction.getClass().equals(SleepAction.class);
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
    }

    private String[] getParameters(TestCase test) {
        ArrayList<String> parameterStrings = new ArrayList<String>();
        for (Map.Entry param : test.getParameters().entrySet()) {
            parameterStrings.add((String)param.getKey() + "=" + param.getValue());
        }
        return parameterStrings.toArray(new String[parameterStrings.size()]);
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    public Map<String, TestResult> getRunningTests() {
        return this.runningTests;
    }

    public void clearResults() {
        this.testResults = new TestResults();
    }

    public int getCountActiveScenarios() {
        return this.runningTests.size();
    }
}

