/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario;

import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.scenario.AbstractSimulatorScenario;
import com.consol.citrus.simulator.scenario.ScenarioStarter;
import com.consol.citrus.simulator.template.TemplateHelper;
import com.consol.citrus.util.FileUtils;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public abstract class AbstractScenarioStarter
extends AbstractSimulatorScenario
implements ScenarioStarter {
    @Autowired
    private SimulatorConfigurationProperties simulatorConfigurationProperties;
    private TemplateHelper templateHelper;

    @PostConstruct
    private void initialiseTemplateHelper() {
        this.templateHelper = TemplateHelper.instance(this.getTemplateBasePath(), FileUtils.getDefaultCharset());
    }

    protected Resource getFileResource(String fileName, String fileExtension) {
        return this.templateHelper.getFileResource(fileName, fileExtension);
    }

    protected String getXmlMessageTemplate(String filename) {
        return this.templateHelper.getXmlMessageTemplate(filename);
    }

    protected String getJsonMessageTemplate(String filename) {
        return this.templateHelper.getJsonMessageTemplate(filename);
    }

    protected String getMessageTemplate(String filename, String fileExtension) {
        return this.templateHelper.getMessageTemplate(filename, fileExtension);
    }

    protected String getTemplateBasePath() {
        return StringUtils.hasText((String)this.simulatorConfigurationProperties.getTemplatePath()) && this.simulatorConfigurationProperties.getTemplatePath().endsWith("/") ? this.simulatorConfigurationProperties.getTemplatePath() : this.simulatorConfigurationProperties.getTemplatePath() + "/";
    }
}

