/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.simulator.endpoint.EndpointMessageHandler;
import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.scenario.ScenarioEndpointConfiguration;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ScenarioEndpoint
extends AbstractEndpoint
implements Producer,
Consumer {
    private final LinkedBlockingQueue<Message> channel = new LinkedBlockingQueue();
    private final Stack<CompletableFuture<Message>> responseFutures = new Stack();

    public ScenarioEndpoint(ScenarioEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public void add(Message request, CompletableFuture<Message> future) {
        this.responseFutures.push(future);
        this.channel.add(request);
    }

    public Producer createProducer() {
        return this;
    }

    public Consumer createConsumer() {
        return this;
    }

    public Message receive(TestContext context) {
        return this.receive(context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        try {
            Message message = this.channel.poll(timeout, TimeUnit.MILLISECONDS);
            if (message == null) {
                throw new SimulatorException("Failed to receive scenario inbound message");
            }
            this.messageReceived(message, context);
            return message;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SimulatorException(e);
        }
    }

    public void send(Message message, TestContext context) {
        this.messageSent(message, context);
        if (this.responseFutures.isEmpty()) {
            throw new SimulatorException("Failed to process scenario response message - missing response consumer");
        }
        this.responseFutures.pop().complete(message);
    }

    private void messageSent(Message message, TestContext context) {
        this.getEndpointMessageHandler(context).handleSentMessage(message, context);
    }

    private void messageReceived(Message message, TestContext context) {
        this.getEndpointMessageHandler(context).handleReceivedMessage(message, context);
    }

    private EndpointMessageHandler getEndpointMessageHandler(TestContext context) {
        return (EndpointMessageHandler)context.getApplicationContext().getBean(EndpointMessageHandler.class);
    }
}

