/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario;

import com.consol.citrus.TestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.BuilderSupport;
import com.consol.citrus.dsl.builder.SoapServerFaultResponseActionBuilder;
import com.consol.citrus.dsl.runner.DefaultTestRunner;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.simulator.correlation.CorrelationBuilderSupport;
import com.consol.citrus.simulator.correlation.CorrelationHandlerBuilder;
import com.consol.citrus.simulator.correlation.StartCorrelationHandlerAction;
import com.consol.citrus.simulator.http.HttpScenarioRunnerActionBuilder;
import com.consol.citrus.simulator.scenario.ScenarioEndpoint;
import com.consol.citrus.simulator.ws.SoapScenarioRunnerActionBuilder;
import com.consol.citrus.ws.actions.SendSoapFaultAction;
import org.springframework.context.ApplicationContext;

public class ScenarioRunner
extends DefaultTestRunner {
    private final ScenarioEndpoint scenarioEndpoint;

    public ScenarioRunner(ScenarioEndpoint scenarioEndpoint, ApplicationContext applicationContext, TestContext context) {
        super(applicationContext, context);
        this.scenarioEndpoint = scenarioEndpoint;
    }

    public StartCorrelationHandlerAction correlation(CorrelationBuilderSupport configurer) {
        CorrelationHandlerBuilder builder = new CorrelationHandlerBuilder(this.scenarioEndpoint, this.getApplicationContext());
        configurer.configure(() -> builder);
        this.doFinally().actions(new TestAction[]{builder.stop()});
        return (StartCorrelationHandlerAction)this.run(builder.build());
    }

    public HttpScenarioRunnerActionBuilder http() {
        return new HttpScenarioRunnerActionBuilder(this, this.scenarioEndpoint).withApplicationContext(this.getApplicationContext());
    }

    public SoapScenarioRunnerActionBuilder soap() {
        return new SoapScenarioRunnerActionBuilder(this, this.scenarioEndpoint).withApplicationContext(this.getApplicationContext());
    }

    public SendSoapFaultAction sendFault(BuilderSupport<SoapServerFaultResponseActionBuilder> configurer) {
        SoapServerFaultResponseActionBuilder actionBuilder = (SoapServerFaultResponseActionBuilder)((SoapServerFaultResponseActionBuilder)new SoapServerFaultResponseActionBuilder(new DelegatingTestAction(), (Endpoint)this.scenarioEndpoint).withApplicationContext(this.getApplicationContext())).description("Sending SOAP fault");
        configurer.configure((AbstractTestActionBuilder)actionBuilder);
        this.run((TestAction)actionBuilder);
        return (SendSoapFaultAction)((DelegatingTestAction)actionBuilder.build()).getDelegate();
    }

    public ScenarioEndpoint scenarioEndpoint() {
        return this.scenarioEndpoint;
    }
}

