/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.scenario.mapper;

import com.consol.citrus.endpoint.adapter.mapping.XPathPayloadMappingKeyExtractor;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ContentBasedXPathScenarioMapper
implements ScenarioMapper {
    private static final Logger LOG = LoggerFactory.getLogger(ContentBasedXPathScenarioMapper.class);
    private final List<XPathPayloadMappingKeyExtractor> keyExtractors = new ArrayList<XPathPayloadMappingKeyExtractor>();
    private final NamespaceContextBuilder namespaceContextBuilder;
    private Predicate<String> mappingKeyFilter = StringUtils::hasLength;

    public ContentBasedXPathScenarioMapper() {
        this(new NamespaceContextBuilder());
    }

    public ContentBasedXPathScenarioMapper(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public ContentBasedXPathScenarioMapper addNamespaceMapping(String alias, String namespaceIdentifier) {
        this.namespaceContextBuilder.getNamespaceMappings().put(alias, namespaceIdentifier);
        return this;
    }

    public ContentBasedXPathScenarioMapper addXPathExpression(String xpathExpression) {
        this.keyExtractors.add(this.createFromXPathExpression(xpathExpression));
        return this;
    }

    public ContentBasedXPathScenarioMapper addMappingKeyFilter(Predicate<String> mappingKeyFilter) {
        this.mappingKeyFilter = mappingKeyFilter;
        return this;
    }

    private XPathPayloadMappingKeyExtractor createFromXPathExpression(String xpathExpression) {
        XPathPayloadMappingKeyExtractor mappingKeyExtractor = new XPathPayloadMappingKeyExtractor();
        mappingKeyExtractor.setNamespaceContextBuilder(this.namespaceContextBuilder);
        mappingKeyExtractor.setXpathExpression(xpathExpression);
        return mappingKeyExtractor;
    }

    public String extractMappingKey(Message request) {
        Optional<String> v = this.keyExtractors.stream().map(keyExtractor -> this.lookupScenarioName(request, (XPathPayloadMappingKeyExtractor)keyExtractor)).filter(Optional::isPresent).map(Optional::get).filter(this.mappingKeyFilter).findFirst();
        return v.orElse(null);
    }

    private Optional<String> lookupScenarioName(Message request, XPathPayloadMappingKeyExtractor keyExtractor) {
        try {
            String mappingKey = keyExtractor.getMappingKey(request);
            LOG.debug("Scenario-name lookup returned: {}", (Object)mappingKey);
            return Optional.of(mappingKey);
        }
        catch (RuntimeException e) {
            LOG.trace("Scenario-name lookup failed", (Throwable)e);
            LOG.debug("Scenario-name lookup returned: <no-match>");
            return Optional.empty();
        }
    }
}

