/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.service;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.simulator.model.Message;
import com.consol.citrus.simulator.model.ScenarioAction;
import com.consol.citrus.simulator.model.ScenarioExecution;
import com.consol.citrus.simulator.model.ScenarioParameter;
import com.consol.citrus.simulator.repository.ScenarioExecutionRepository;
import com.consol.citrus.simulator.service.MessageService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ActivityService {
    private final ScenarioExecutionRepository scenarioExecutionRepository;
    private final MessageService messageService;

    @Autowired
    public ActivityService(ScenarioExecutionRepository scenarioExecutionRepository, MessageService messageService) {
        this.scenarioExecutionRepository = scenarioExecutionRepository;
        this.messageService = messageService;
    }

    public ScenarioExecution createExecutionScenario(String scenarioName, Collection<ScenarioParameter> scenarioParameters) {
        ScenarioExecution ts = new ScenarioExecution();
        ts.setScenarioName(scenarioName);
        ts.setStartDate(this.getTimeNow());
        ts.setStatus(ScenarioExecution.Status.ACTIVE);
        if (scenarioParameters != null) {
            for (ScenarioParameter tp : scenarioParameters) {
                ts.addScenarioParameter(tp);
            }
        }
        ts = (ScenarioExecution)this.scenarioExecutionRepository.save(ts);
        return ts;
    }

    public void completeScenarioExecutionSuccess(TestCase testCase) {
        this.completeScenarioExecution(ScenarioExecution.Status.SUCCESS, testCase, null);
    }

    public void completeScenarioExecutionFailure(TestCase testCase, Throwable cause) {
        this.completeScenarioExecution(ScenarioExecution.Status.FAILED, testCase, cause);
    }

    public Collection<ScenarioExecution> getScenarioExecutionsByName(String testName) {
        return this.scenarioExecutionRepository.findByScenarioNameOrderByStartDateDesc(testName);
    }

    public Collection<ScenarioExecution> getScenarioExecutionsByStatus(ScenarioExecution.Status status) {
        return this.scenarioExecutionRepository.findByStatusOrderByStartDateDesc(status);
    }

    public ScenarioExecution getScenarioExecutionById(Long id) {
        return (ScenarioExecution)this.scenarioExecutionRepository.findOne(id);
    }

    public Message saveScenarioMessage(Long executionId, Message.Direction direction, String payload, String citrusMessageId, Map<String, Object> headers) {
        Object message;
        ScenarioExecution se = this.getScenarioExecutionById(executionId);
        Collection<Message> messages = se.getScenarioMessages();
        if (messages != null && ((Optional)(message = messages.stream().filter(scenarioMessage -> scenarioMessage.getCitrusMessageId().equalsIgnoreCase(citrusMessageId)).findFirst())).isPresent()) {
            return (Message)((Optional)message).get();
        }
        message = this.messageService.saveMessage(direction, payload, citrusMessageId, headers);
        se.addScenarioMessage((Message)message);
        return message;
    }

    public void clearScenarioExecutions() {
        this.scenarioExecutionRepository.deleteAll();
    }

    public Collection<ScenarioExecution> getScenarioExecutionsByStartDate(Date fromDate, Date toDate, Integer page, Integer size) {
        Integer calcSize;
        Integer calcPage;
        Date calcToDate;
        Date calcFromDate = fromDate;
        if (calcFromDate == null) {
            calcFromDate = Date.from(LocalDate.now().atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        if ((calcToDate = toDate) == null) {
            calcToDate = Date.from(LocalDate.now().plusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        if ((calcPage = page) == null) {
            calcPage = 0;
        }
        if ((calcSize = size) == null) {
            calcSize = 25;
        }
        PageRequest pageable = new PageRequest(calcPage.intValue(), calcSize.intValue());
        return this.scenarioExecutionRepository.findByStartDateBetweenOrderByStartDateDesc(calcFromDate, calcToDate, (Pageable)pageable);
    }

    private void completeScenarioExecution(ScenarioExecution.Status status, TestCase testCase, Throwable cause) {
        ScenarioExecution te = this.lookupScenarioExecution(testCase);
        te.setEndDate(this.getTimeNow());
        te.setStatus(status);
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            te.setErrorMessage(sw.toString());
        }
    }

    public void createTestAction(TestCase testCase, TestAction testAction) {
        if (this.skipTestAction(testAction)) {
            return;
        }
        ScenarioExecution te = this.lookupScenarioExecution(testCase);
        ScenarioAction ta = new ScenarioAction();
        ta.setName(testAction.getName());
        ta.setStartDate(this.getTimeNow());
        te.addScenarioAction(ta);
    }

    public void completeTestAction(TestCase testCase, TestAction testAction) {
        if (this.skipTestAction(testAction)) {
            return;
        }
        ScenarioExecution te = this.lookupScenarioExecution(testCase);
        Iterator<ScenarioAction> iterator = te.getScenarioActions().iterator();
        ScenarioAction lastScenarioAction = null;
        while (iterator.hasNext()) {
            lastScenarioAction = iterator.next();
        }
        if (lastScenarioAction == null) {
            throw new CitrusRuntimeException(String.format("No test action found with name %s", testAction.getName()));
        }
        if (!lastScenarioAction.getName().equals(testAction.getName())) {
            throw new CitrusRuntimeException(String.format("Expected to find last test action with name %s but got %s", testAction.getName(), lastScenarioAction.getName()));
        }
        lastScenarioAction.setEndDate(this.getTimeNow());
    }

    private boolean skipTestAction(TestAction testAction) {
        List<String> ignoreList = Arrays.asList("create-variables");
        return ignoreList.contains(testAction.getName());
    }

    private ScenarioExecution lookupScenarioExecution(TestCase testCase) {
        return (ScenarioExecution)this.scenarioExecutionRepository.findOne(Long.valueOf(this.lookupScenarioExecutionId(testCase)));
    }

    private long lookupScenarioExecutionId(TestCase testCase) {
        return Long.parseLong(testCase.getVariableDefinitions().get("scenarioExecutionId").toString());
    }

    private Date getTimeNow() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }
}

