/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.service;

import com.consol.citrus.simulator.model.Message;
import com.consol.citrus.simulator.model.MessageFilter;
import com.consol.citrus.simulator.model.MessageHeader;
import com.consol.citrus.simulator.repository.MessageRepository;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class MessageService {
    private final MessageRepository messageRepository;

    @Autowired
    public MessageService(MessageRepository messageRepository) {
        this.messageRepository = messageRepository;
    }

    public Message saveMessage(Message.Direction direction, String payload, String citrusMessageId, Map<String, Object> headers) {
        Message message = new Message();
        message.setDate(this.now());
        message.setDirection(direction);
        message.setPayload(payload);
        message.setCitrusMessageId(citrusMessageId);
        if (headers != null) {
            headers.entrySet().stream().forEach(headerEntry -> message.addHeader(new MessageHeader((String)headerEntry.getKey(), StringUtils.abbreviate((String)headerEntry.getValue().toString(), (int)255))));
        }
        return (Message)this.messageRepository.save(message);
    }

    public Message getMessageById(Long id) {
        return (Message)this.messageRepository.findOne(id);
    }

    public List<Message> getMessagesMatchingFilter(MessageFilter filter) {
        Date calcFromDate = Optional.ofNullable(filter.getFromDate()).orElse(this.startOfDay());
        Date calcToDate = Optional.ofNullable(filter.getFromDate()).orElse(this.endOfDay());
        Integer calcPage = Optional.ofNullable(filter.getPageNumber()).orElse(0);
        Integer calcSize = Optional.ofNullable(filter.getPageSize()).orElse(25);
        boolean includeInbound = Optional.ofNullable(filter.getDirectionInbound()).orElse(true);
        boolean includeOutbound = Optional.ofNullable(filter.getDirectionOutbound()).orElse(true);
        TreeSet<Message.Direction> includeDirections = new TreeSet<Message.Direction>();
        if (includeInbound) {
            includeDirections.add(Message.Direction.INBOUND);
        }
        if (includeOutbound) {
            includeDirections.add(Message.Direction.OUTBOUND);
        }
        PageRequest pageable = new PageRequest(calcPage.intValue(), calcSize.intValue(), Sort.Direction.DESC, new String[]{"date"});
        if (StringUtils.isNotEmpty((String)filter.getContainingText())) {
            return this.messageRepository.findByDateBetweenAndDirectionInAndPayloadContainingIgnoreCase(calcFromDate, calcToDate, includeDirections, filter.getContainingText(), (Pageable)pageable);
        }
        return this.messageRepository.findByDateBetweenAndDirectionIn(calcFromDate, calcToDate, includeDirections, (Pageable)pageable);
    }

    public void clearMessages() {
        this.messageRepository.deleteAll();
    }

    private Date now() {
        return Date.from(LocalDateTime.now().atZone(ZoneOffset.UTC).toInstant());
    }

    private Date startOfDay() {
        return Date.from(LocalDate.now().atStartOfDay().toInstant(ZoneOffset.UTC));
    }

    private Date endOfDay() {
        return Date.from(LocalDate.now().plusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC));
    }
}

