/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.service;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.endpoint.Executable;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.simulator.exception.SimulatorException;
import com.consol.citrus.simulator.model.ScenarioExecution;
import com.consol.citrus.simulator.model.ScenarioParameter;
import com.consol.citrus.simulator.scenario.ScenarioDesigner;
import com.consol.citrus.simulator.scenario.ScenarioRunner;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.service.ActivityService;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class ScenarioExecutionService
implements DisposableBean,
ApplicationListener<ContextClosedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioExecutionService.class);
    private final ActivityService activityService;
    private final ApplicationContext applicationContext;
    private final Citrus citrus;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    @Autowired
    public ScenarioExecutionService(ActivityService activityService, ApplicationContext applicationContext, Citrus citrus) {
        this.activityService = activityService;
        this.applicationContext = applicationContext;
        this.citrus = citrus;
    }

    public final Long run(String name, List<ScenarioParameter> scenarioParameters) {
        return this.run((SimulatorScenario)this.applicationContext.getBean(name, SimulatorScenario.class), name, scenarioParameters);
    }

    public final Long run(SimulatorScenario scenario, String name, List<ScenarioParameter> scenarioParameters) {
        LOG.info(String.format("Starting scenario : %s", name));
        ScenarioExecution es = this.activityService.createExecutionScenario(name, scenarioParameters);
        this.prepare(scenario);
        this.startScenarioAsync(es.getExecutionId(), name, scenario, scenarioParameters);
        return es.getExecutionId();
    }

    private Future<?> startScenarioAsync(Long executionId, String name, SimulatorScenario scenario, List<ScenarioParameter> scenarioParameters) {
        return this.executorService.submit(() -> {
            try {
                if (scenario instanceof Executable) {
                    if (scenarioParameters != null) {
                        scenarioParameters.forEach(p -> this.addVariable(scenario, p.getName(), p.getValue()));
                    }
                    this.addVariable(scenario, "scenarioExecutionId", executionId);
                    ((Executable)scenario).execute();
                } else {
                    TestContext context = this.citrus.createTestContext();
                    ReflectionUtils.doWithLocalMethods(scenario.getClass(), m -> {
                        if (m.getDeclaringClass().equals(SimulatorScenario.class)) {
                            return;
                        }
                        if (!m.getName().equals("run")) {
                            return;
                        }
                        if (m.getParameterCount() != 1) {
                            throw new SimulatorException("Invalid scenario method signature - expect single method parameter but got: " + m.getParameterCount());
                        }
                        Class<?> parameterType = m.getParameterTypes()[0];
                        if (parameterType.equals(ScenarioDesigner.class)) {
                            ScenarioDesigner designer = new ScenarioDesigner(scenario.getScenarioEndpoint(), this.citrus.getApplicationContext(), context);
                            if (scenarioParameters != null) {
                                scenarioParameters.forEach(p -> designer.variable(p.getName(), p.getValue()));
                            }
                            designer.variable("scenarioExecutionId", executionId);
                            CitrusAnnotations.injectAll((Object)scenario, (Citrus)this.citrus, (TestContext)context);
                            ReflectionUtils.invokeMethod((Method)m, (Object)scenario, (Object[])new Object[]{designer});
                            this.citrus.run((TestAction)designer.getTestCase(), context);
                        } else if (parameterType.equals(ScenarioRunner.class)) {
                            ScenarioRunner runner = new ScenarioRunner(scenario.getScenarioEndpoint(), this.citrus.getApplicationContext(), context);
                            if (scenarioParameters != null) {
                                scenarioParameters.forEach(p -> {
                                    String cfr_ignored_0 = (String)runner.variable(p.getName(), p.getValue());
                                });
                            }
                            runner.variable("scenarioExecutionId", executionId);
                            CitrusAnnotations.injectAll((Object)scenario, (Citrus)this.citrus, (TestContext)context);
                            try {
                                runner.start();
                                ReflectionUtils.invokeMethod((Method)m, (Object)scenario, (Object[])new Object[]{runner});
                            }
                            finally {
                                runner.stop();
                            }
                        } else {
                            throw new SimulatorException("Invalid scenario method parameter type: " + parameterType);
                        }
                    });
                }
                LOG.debug(String.format("Scenario completed: '%s'", name));
            }
            catch (Exception e) {
                LOG.error(String.format("Scenario completed with error: '%s'", name), (Throwable)e);
            }
        });
    }

    private void addVariable(SimulatorScenario scenario, String key, Object value) {
        if (scenario instanceof TestDesigner) {
            ((TestDesigner)scenario).variable(key, value);
        }
        if (scenario instanceof TestRunner) {
            ((TestRunner)scenario).variable(key, value);
        }
    }

    protected void prepare(SimulatorScenario scenario) {
    }

    public void destroy() throws Exception {
        this.executorService.shutdownNow();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.executorService.shutdownNow();
    }
}

