/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.service;

import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.template.TemplateHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TemplateService {
    private final SimulatorConfigurationProperties simulatorConfigurationProperties;
    private TemplateHelper templateHelper;

    public TemplateService(SimulatorConfigurationProperties simulatorConfigurationProperties) {
        this.simulatorConfigurationProperties = simulatorConfigurationProperties;
        this.templateHelper = TemplateService.createTemplateHelper(simulatorConfigurationProperties);
    }

    public String getMessageTemplate(String templatePath, String templateExtension) {
        return this.templateHelper.getMessageTemplate(templatePath, templateExtension);
    }

    public String getXmlMessageTemplate(String templatePath) {
        return this.templateHelper.getXmlMessageTemplate(templatePath);
    }

    public String getJsonMessageTemplate(String templatePath) {
        return this.templateHelper.getJsonMessageTemplate(templatePath);
    }

    private static TemplateHelper createTemplateHelper(SimulatorConfigurationProperties simulatorConfigurationProperties) {
        String basePath = simulatorConfigurationProperties.getTemplatePath();
        if (StringUtils.hasLength((String)basePath) && !StringUtils.endsWithIgnoreCase((String)basePath, (String)"/")) {
            basePath = simulatorConfigurationProperties.getTemplatePath() + "/";
        }
        return TemplateHelper.instance(basePath);
    }
}

